/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.credentials.client.impl;

import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.client.TransferWisePaths;
import travel.wink.wise.partner.credentials.api.CreatePersonalProfile;
import travel.wink.wise.partner.credentials.api.UpdatePersonalProfile;
import travel.wink.wise.partner.credentials.api.WiseProfile;
import travel.wink.wise.partner.credentials.api.WiseProfileResponse;
import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import travel.wink.wise.partner.credentials.client.WiseProfileClient;

public class WiseProfileClientImpl
implements WiseProfileClient {
    private final WebClient client;

    @Override
    public Mono<WiseProfile> createPersonalProfile(WiseUserTokens twUserTokens, CreatePersonalProfile createPersonalProfile) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri("/v1/profiles", new Object[0])).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{twUserTokens.bearer()})).bodyValue((Object)createPersonalProfile).retrieve().bodyToMono(WiseProfileResponse.class).map(response -> WiseProfile.of(twUserTokens.getCustomerId(), response));
    }

    @Override
    public Mono<WiseProfile> updatePersonalProfile(WiseUserTokens twUserTokens, UpdatePersonalProfile updatePersonalProfile) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.put().uri("/v1/profiles", new Object[0])).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{twUserTokens.bearer()})).bodyValue((Object)updatePersonalProfile).retrieve().bodyToMono(WiseProfileResponse.class).map(response -> WiseProfile.of(twUserTokens.getCustomerId(), response));
    }

    @Override
    public Mono<WiseProfile> getProfile(WiseUserTokens twUserTokens, Long twProfileId) {
        return this.client.get().uri(TransferWisePaths.getProfilePath(twProfileId), new Object[0]).header("Authorization", new String[]{twUserTokens.bearer()}).retrieve().bodyToMono(WiseProfileResponse.class).map(response -> WiseProfile.of(twUserTokens.getCustomerId(), response));
    }

    @Override
    public Flux<WiseProfile> getProfiles(WiseUserTokens twUserTokens) {
        return this.client.get().uri("/v1/profiles", new Object[0]).header("Authorization", new String[]{twUserTokens.bearer()}).retrieve().bodyToFlux(WiseProfileResponse.class).map(response -> WiseProfile.of(twUserTokens.getCustomerId(), response));
    }

    @Override
    public Mono<Boolean> openUpdateWindow(WiseUserTokens twUserTokens, Long twProfileId) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri(TransferWisePaths.updateWindowPath(twProfileId), new Object[0])).header("Authorization", new String[]{twUserTokens.bearer()})).exchangeToMono(clientResponse -> Mono.just((Object)clientResponse.statusCode().is2xxSuccessful()));
    }

    @Override
    public Mono<Boolean> closeUpdateWindow(WiseUserTokens twUserTokens, Long twProfileId) {
        return this.client.delete().uri(TransferWisePaths.updateWindowPath(twProfileId), new Object[0]).header("Authorization", new String[]{twUserTokens.bearer()}).exchangeToMono(clientResponse -> Mono.just((Object)clientResponse.statusCode().is2xxSuccessful()));
    }

    public WiseProfileClientImpl(WebClient client) {
        this.client = client;
    }
}

