/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.customer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import travel.wink.wise.partner.customer.api.Occupation;

public final class Address {
    private final Long id;
    private final String firstLine;
    private final String postCode;
    private final String city;
    private final String state;
    private final String country;
    private final List<Occupation> occupations;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"id", "firstLine", "postCode", "city", "state", "country", "occupations"})
    public Address(@JsonProperty(value="id") Long id, @JsonProperty(value="firstLine") String firstLine, @JsonProperty(value="postCode") String postCode, @JsonProperty(value="city") String city, @JsonProperty(value="state") String state, @JsonProperty(value="country") String country, @JsonProperty(value="occupations") List<Occupation> occupations) {
        this.id = id;
        this.firstLine = firstLine;
        this.postCode = postCode;
        this.city = city;
        this.state = state;
        this.country = country;
        this.occupations = Objects.requireNonNullElse(occupations, Collections.emptyList());
    }

    public static Address of(Long id, String firstLine, String postCode, String city, String state, String country) {
        return new Address(id, firstLine, postCode, city, state, country, null);
    }

    public static Address of(String firstLine, String postCode, String city, String state, String country) {
        return new Address(null, firstLine, postCode, city, state, country, null);
    }

    public static Address of(Long id, String firstLine, String postCode, String city, String state, String country, List<Occupation> occupations) {
        return new Address(id, firstLine, postCode, city, state, country, occupations);
    }

    public static Address of(String firstLine, String postCode, String city, String state, String country, List<Occupation> occupations) {
        return new Address(null, firstLine, postCode, city, state, country, occupations);
    }

    public Long getId() {
        return this.id;
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getCountry() {
        return this.country;
    }

    public List<Occupation> getOccupations() {
        return this.occupations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$firstLine = this.getFirstLine();
        String other$firstLine = other.getFirstLine();
        if (this$firstLine == null ? other$firstLine != null : !this$firstLine.equals(other$firstLine)) {
            return false;
        }
        String this$postCode = this.getPostCode();
        String other$postCode = other.getPostCode();
        if (this$postCode == null ? other$postCode != null : !this$postCode.equals(other$postCode)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        List<Occupation> this$occupations = this.getOccupations();
        List<Occupation> other$occupations = other.getOccupations();
        return !(this$occupations == null ? other$occupations != null : !((Object)this$occupations).equals(other$occupations));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $firstLine = this.getFirstLine();
        result = result * 59 + ($firstLine == null ? 43 : $firstLine.hashCode());
        String $postCode = this.getPostCode();
        result = result * 59 + ($postCode == null ? 43 : $postCode.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        List<Occupation> $occupations = this.getOccupations();
        result = result * 59 + ($occupations == null ? 43 : ((Object)$occupations).hashCode());
        return result;
    }

    public String toString() {
        return "Address(id=" + this.getId() + ", firstLine=" + this.getFirstLine() + ", postCode=" + this.getPostCode() + ", city=" + this.getCity() + ", state=" + this.getState() + ", country=" + this.getCountry() + ", occupations=" + String.valueOf(this.getOccupations()) + ")";
    }
}

