/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.customer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import org.apache.commons.lang3.BooleanUtils;
import travel.wink.wise.partner.customer.api.Address;

public final class Customer {
    private final Long id;
    private final String firstName;
    private final String lastName;
    private final LocalDate dateOfBirth;
    private final String phoneNumber;
    private final String email;
    private final boolean transferWiseAccountLinked;
    private final Address address;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"id", "firstName", "lastName", "dateOfBirth", "phoneNumber", "email", "transferWiseAccountLinked", "address"})
    public Customer(@JsonProperty(value="id") Long id, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="dateOfBirth") @JsonFormat(pattern="yyyy-MM-dd") LocalDate dateOfBirth, @JsonProperty(value="phoneNumber") String phoneNumber, @JsonProperty(value="email") String email, @JsonProperty(value="transferWiseAccountLinked") Boolean transferWiseAccountLinked, @JsonProperty(value="address") Address address) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.dateOfBirth = dateOfBirth;
        this.phoneNumber = phoneNumber;
        this.email = email;
        this.transferWiseAccountLinked = BooleanUtils.isTrue((Boolean)transferWiseAccountLinked);
        this.address = address;
    }

    public static Customer of(String firstName, String lastName, LocalDate dateOfBirth, String phoneNumber, String email, Address address) {
        return new Customer(null, firstName, lastName, dateOfBirth, phoneNumber, email, null, address);
    }

    public Customer updateTransferWiseAccountLinked(boolean transferWiseAccountLinked) {
        return new Customer(this.id, this.firstName, this.lastName, this.dateOfBirth, this.phoneNumber, this.email, transferWiseAccountLinked, this.address);
    }

    public Long getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isTransferWiseAccountLinked() {
        return this.transferWiseAccountLinked;
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)o;
        if (this.isTransferWiseAccountLinked() != other.isTransferWiseAccountLinked()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        LocalDate this$dateOfBirth = this.getDateOfBirth();
        LocalDate other$dateOfBirth = other.getDateOfBirth();
        if (this$dateOfBirth == null ? other$dateOfBirth != null : !((Object)this$dateOfBirth).equals(other$dateOfBirth)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTransferWiseAccountLinked() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        LocalDate $dateOfBirth = this.getDateOfBirth();
        result = result * 59 + ($dateOfBirth == null ? 43 : ((Object)$dateOfBirth).hashCode());
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    public String toString() {
        return "Customer(id=" + this.getId() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", dateOfBirth=" + String.valueOf(this.getDateOfBirth()) + ", phoneNumber=" + this.getPhoneNumber() + ", email=" + this.getEmail() + ", transferWiseAccountLinked=" + this.isTransferWiseAccountLinked() + ", address=" + String.valueOf(this.getAddress()) + ")";
    }
}

