/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.customer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import org.springframework.util.Assert;
import travel.wink.wise.partner.customer.api.NewAddressRequest;

public final class NewCustomerRequest {
    @NotNull
    private final String firstName;
    @NotNull
    private final String lastName;
    @NotNull
    @Email
    private final String email;
    @NotNull
    private final LocalDate dateOfBirth;
    @NotNull
    private final String phoneNumber;
    @NotNull
    private final NewAddressRequest address;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"firstName", "lastName", "email", "dateOfBirth", "phoneNumber", "address"})
    public NewCustomerRequest(@JsonProperty(value="firstName") @NotNull String firstName, @JsonProperty(value="lastName") @NotNull String lastName, @JsonProperty(value="email") @NotNull @Email String email, @JsonProperty(value="dateOfBirth") @NotNull @JsonFormat(pattern="yyyy-MM-dd") LocalDate dateOfBirth, @JsonProperty(value="phoneNumber") @NotNull String phoneNumber, @JsonProperty(value="address") @NotNull NewAddressRequest address) {
        Assert.notNull((Object)firstName, (String)"firstName must not be null");
        Assert.notNull((Object)lastName, (String)"lastName must not be null");
        Assert.notNull((Object)email, (String)"email must not be null");
        Assert.notNull((Object)dateOfBirth, (String)"dateOfBirth must not be null");
        Assert.notNull((Object)phoneNumber, (String)"phoneNumber must not be null");
        Assert.notNull((Object)address, (String)"address must not be null");
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.dateOfBirth = dateOfBirth;
        this.phoneNumber = phoneNumber;
        this.address = address;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public NewAddressRequest getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewCustomerRequest)) {
            return false;
        }
        NewCustomerRequest other = (NewCustomerRequest)o;
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        LocalDate this$dateOfBirth = this.getDateOfBirth();
        LocalDate other$dateOfBirth = other.getDateOfBirth();
        if (this$dateOfBirth == null ? other$dateOfBirth != null : !((Object)this$dateOfBirth).equals(other$dateOfBirth)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        NewAddressRequest this$address = this.getAddress();
        NewAddressRequest other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        LocalDate $dateOfBirth = this.getDateOfBirth();
        result = result * 59 + ($dateOfBirth == null ? 43 : ((Object)$dateOfBirth).hashCode());
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        NewAddressRequest $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    public String toString() {
        return "NewCustomerRequest(firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", dateOfBirth=" + String.valueOf(this.getDateOfBirth()) + ", phoneNumber=" + this.getPhoneNumber() + ", address=" + String.valueOf(this.getAddress()) + ")";
    }
}

