/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import travel.wink.wise.partner.quote.api.DisabledReason;
import travel.wink.wise.partner.quote.api.Fee;

public final class PaymentOption {
    public static final String BANK_TRANSFER = "BANK_TRANSFER";
    public static final String SWIFT = "SWIFT";
    private final Boolean disabled;
    private final LocalDateTime estimatedDelivery;
    private final String formattedEstimatedDelivery;
    private final List<String> estimatedDeliveryDelays;
    private final Fee fee;
    private final BigDecimal sourceAmount;
    private final BigDecimal targetAmount;
    private final String payIn;
    private final String payOut;
    private final List<String> allowedProfileTypes;
    private final DisabledReason disabledReason;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"disabled", "estimatedDelivery", "formattedEstimatedDelivery", "estimatedDeliveryDelays", "fee", "sourceAmount", "targetAmount", "payIn", "payOut", "allowedProfileTypes", "disabledReason"})
    public PaymentOption(@JsonProperty(value="disabled") Boolean disabled, @JsonProperty(value="estimatedDelivery") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'") LocalDateTime estimatedDelivery, @JsonProperty(value="formattedEstimatedDelivery") String formattedEstimatedDelivery, @JsonProperty(value="estimatedDeliveryDelays") List<String> estimatedDeliveryDelays, @JsonProperty(value="fee") Fee fee, @JsonProperty(value="sourceAmount") BigDecimal sourceAmount, @JsonProperty(value="targetAmount") BigDecimal targetAmount, @JsonProperty(value="payIn") String payIn, @JsonProperty(value="payOut") String payOut, @JsonProperty(value="allowedProfileTypes") List<String> allowedProfileTypes, @JsonProperty(value="disabledReason") DisabledReason disabledReason) {
        this.disabled = disabled;
        this.estimatedDelivery = estimatedDelivery;
        this.formattedEstimatedDelivery = formattedEstimatedDelivery;
        this.estimatedDeliveryDelays = Objects.requireNonNullElse(estimatedDeliveryDelays, Collections.emptyList());
        this.fee = fee;
        this.sourceAmount = sourceAmount;
        this.targetAmount = targetAmount;
        this.payIn = payIn;
        this.payOut = payOut;
        this.allowedProfileTypes = Objects.requireNonNullElse(allowedProfileTypes, Collections.emptyList());
        this.disabledReason = disabledReason;
    }

    public static PaymentOption of(String payIn, String payOut) {
        return new PaymentOption(null, null, null, null, null, null, null, payIn, payOut, null, null);
    }

    public boolean isSwift() {
        return this.payIn.equals(SWIFT) && this.payOut.equals(BANK_TRANSFER);
    }

    public boolean isBankTransfer() {
        return this.payIn.equals(BANK_TRANSFER) && this.payOut.equals(BANK_TRANSFER);
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public LocalDateTime getEstimatedDelivery() {
        return this.estimatedDelivery;
    }

    public String getFormattedEstimatedDelivery() {
        return this.formattedEstimatedDelivery;
    }

    public List<String> getEstimatedDeliveryDelays() {
        return this.estimatedDeliveryDelays;
    }

    public Fee getFee() {
        return this.fee;
    }

    public BigDecimal getSourceAmount() {
        return this.sourceAmount;
    }

    public BigDecimal getTargetAmount() {
        return this.targetAmount;
    }

    public String getPayIn() {
        return this.payIn;
    }

    public String getPayOut() {
        return this.payOut;
    }

    public List<String> getAllowedProfileTypes() {
        return this.allowedProfileTypes;
    }

    public DisabledReason getDisabledReason() {
        return this.disabledReason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentOption)) {
            return false;
        }
        PaymentOption other = (PaymentOption)o;
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        LocalDateTime this$estimatedDelivery = this.getEstimatedDelivery();
        LocalDateTime other$estimatedDelivery = other.getEstimatedDelivery();
        if (this$estimatedDelivery == null ? other$estimatedDelivery != null : !((Object)this$estimatedDelivery).equals(other$estimatedDelivery)) {
            return false;
        }
        String this$formattedEstimatedDelivery = this.getFormattedEstimatedDelivery();
        String other$formattedEstimatedDelivery = other.getFormattedEstimatedDelivery();
        if (this$formattedEstimatedDelivery == null ? other$formattedEstimatedDelivery != null : !this$formattedEstimatedDelivery.equals(other$formattedEstimatedDelivery)) {
            return false;
        }
        List<String> this$estimatedDeliveryDelays = this.getEstimatedDeliveryDelays();
        List<String> other$estimatedDeliveryDelays = other.getEstimatedDeliveryDelays();
        if (this$estimatedDeliveryDelays == null ? other$estimatedDeliveryDelays != null : !((Object)this$estimatedDeliveryDelays).equals(other$estimatedDeliveryDelays)) {
            return false;
        }
        Fee this$fee = this.getFee();
        Fee other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        BigDecimal this$sourceAmount = this.getSourceAmount();
        BigDecimal other$sourceAmount = other.getSourceAmount();
        if (this$sourceAmount == null ? other$sourceAmount != null : !((Object)this$sourceAmount).equals(other$sourceAmount)) {
            return false;
        }
        BigDecimal this$targetAmount = this.getTargetAmount();
        BigDecimal other$targetAmount = other.getTargetAmount();
        if (this$targetAmount == null ? other$targetAmount != null : !((Object)this$targetAmount).equals(other$targetAmount)) {
            return false;
        }
        String this$payIn = this.getPayIn();
        String other$payIn = other.getPayIn();
        if (this$payIn == null ? other$payIn != null : !this$payIn.equals(other$payIn)) {
            return false;
        }
        String this$payOut = this.getPayOut();
        String other$payOut = other.getPayOut();
        if (this$payOut == null ? other$payOut != null : !this$payOut.equals(other$payOut)) {
            return false;
        }
        List<String> this$allowedProfileTypes = this.getAllowedProfileTypes();
        List<String> other$allowedProfileTypes = other.getAllowedProfileTypes();
        if (this$allowedProfileTypes == null ? other$allowedProfileTypes != null : !((Object)this$allowedProfileTypes).equals(other$allowedProfileTypes)) {
            return false;
        }
        DisabledReason this$disabledReason = this.getDisabledReason();
        DisabledReason other$disabledReason = other.getDisabledReason();
        return !(this$disabledReason == null ? other$disabledReason != null : !((Object)this$disabledReason).equals(other$disabledReason));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        LocalDateTime $estimatedDelivery = this.getEstimatedDelivery();
        result = result * 59 + ($estimatedDelivery == null ? 43 : ((Object)$estimatedDelivery).hashCode());
        String $formattedEstimatedDelivery = this.getFormattedEstimatedDelivery();
        result = result * 59 + ($formattedEstimatedDelivery == null ? 43 : $formattedEstimatedDelivery.hashCode());
        List<String> $estimatedDeliveryDelays = this.getEstimatedDeliveryDelays();
        result = result * 59 + ($estimatedDeliveryDelays == null ? 43 : ((Object)$estimatedDeliveryDelays).hashCode());
        Fee $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        BigDecimal $sourceAmount = this.getSourceAmount();
        result = result * 59 + ($sourceAmount == null ? 43 : ((Object)$sourceAmount).hashCode());
        BigDecimal $targetAmount = this.getTargetAmount();
        result = result * 59 + ($targetAmount == null ? 43 : ((Object)$targetAmount).hashCode());
        String $payIn = this.getPayIn();
        result = result * 59 + ($payIn == null ? 43 : $payIn.hashCode());
        String $payOut = this.getPayOut();
        result = result * 59 + ($payOut == null ? 43 : $payOut.hashCode());
        List<String> $allowedProfileTypes = this.getAllowedProfileTypes();
        result = result * 59 + ($allowedProfileTypes == null ? 43 : ((Object)$allowedProfileTypes).hashCode());
        DisabledReason $disabledReason = this.getDisabledReason();
        result = result * 59 + ($disabledReason == null ? 43 : ((Object)$disabledReason).hashCode());
        return result;
    }

    public String toString() {
        return "PaymentOption(disabled=" + this.getDisabled() + ", estimatedDelivery=" + String.valueOf(this.getEstimatedDelivery()) + ", formattedEstimatedDelivery=" + this.getFormattedEstimatedDelivery() + ", estimatedDeliveryDelays=" + String.valueOf(this.getEstimatedDeliveryDelays()) + ", fee=" + String.valueOf(this.getFee()) + ", sourceAmount=" + String.valueOf(this.getSourceAmount()) + ", targetAmount=" + String.valueOf(this.getTargetAmount()) + ", payIn=" + this.getPayIn() + ", payOut=" + this.getPayOut() + ", allowedProfileTypes=" + String.valueOf(this.getAllowedProfileTypes()) + ", disabledReason=" + String.valueOf(this.getDisabledReason()) + ")";
    }
}

