/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import travel.wink.wise.partner.quote.api.PaymentOption;
import travel.wink.wise.partner.quote.api.QuoteNotice;

public final class Quote {
    private static final String BANK_TRANSFER = "BANK_TRANSFER";
    private final UUID id;
    private final String sourceCurrency;
    private final String targetCurrency;
    private final BigDecimal sourceAmount;
    private final BigDecimal targetAmount;
    private final String payOut;
    private final BigDecimal rate;
    private final LocalDateTime createdTime;
    private final BigDecimal fee;
    private final Integer user;
    private final Integer profile;
    private final String rateType;
    private final LocalDateTime rateExpirationTime;
    private final String providedAmountType;
    private final String status;
    private final LocalDateTime expirationTime;
    private final List<QuoteNotice> notices;
    private final List<PaymentOption> paymentOptions;
    private final String formattedEstimatedDelivery;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"id", "sourceCurrency", "targetCurrency", "sourceAmount", "targetAmount", "payOut", "rate", "createdTime", "fee", "user", "profile", "rateType", "rateExpirationTime", "providedAmountType", "impl", "expirationTime", "notices", "paymentOptions", "formattedEstimatedDelivery"})
    public Quote(@JsonProperty(value="id") UUID id, @JsonProperty(value="sourceCurrency") String sourceCurrency, @JsonProperty(value="targetCurrency") String targetCurrency, @JsonProperty(value="sourceAmount") BigDecimal sourceAmount, @JsonProperty(value="targetAmount") BigDecimal targetAmount, @JsonProperty(value="payOut") String payOut, @JsonProperty(value="rate") BigDecimal rate, @JsonProperty(value="createdTime") LocalDateTime createdTime, @JsonProperty(value="fee") BigDecimal fee, @JsonProperty(value="user") Integer user, @JsonProperty(value="profile") Integer profile, @JsonProperty(value="rateType") String rateType, @JsonProperty(value="rateExpirationTime") LocalDateTime rateExpirationTime, @JsonProperty(value="providedAmountType") String providedAmountType, @JsonProperty(value="impl") String status, @JsonProperty(value="expirationTime") LocalDateTime expirationTime, @JsonProperty(value="notices") List<QuoteNotice> notices, @JsonProperty(value="paymentOptions") List<PaymentOption> paymentOptions, @JsonProperty(value="formattedEstimatedDelivery") String formattedEstimatedDelivery) {
        this.id = id;
        this.sourceCurrency = sourceCurrency;
        this.targetCurrency = targetCurrency;
        this.sourceAmount = sourceAmount;
        this.targetAmount = targetAmount;
        this.payOut = payOut;
        this.rate = rate;
        this.createdTime = createdTime;
        this.fee = fee;
        this.user = user;
        this.profile = profile;
        this.rateType = rateType;
        this.rateExpirationTime = rateExpirationTime;
        this.providedAmountType = providedAmountType;
        this.status = status;
        this.expirationTime = expirationTime;
        this.notices = Objects.requireNonNullElse(notices, Collections.emptyList());
        this.paymentOptions = Objects.requireNonNullElse(paymentOptions, Collections.emptyList());
        this.formattedEstimatedDelivery = formattedEstimatedDelivery;
    }

    public static Quote of(List<PaymentOption> paymentOptions) {
        return new Quote(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, paymentOptions, null);
    }

    public Quote updateFee(BigDecimal fee) {
        return new Quote(this.id, this.sourceCurrency, this.targetCurrency, this.sourceAmount, this.targetAmount, this.payOut, this.rate, this.createdTime, fee, this.user, this.profile, this.rateType, this.rateExpirationTime, this.providedAmountType, this.status, this.expirationTime, this.notices, this.paymentOptions, this.formattedEstimatedDelivery);
    }

    public Quote updateSourceAmount(BigDecimal sourceAmount) {
        return new Quote(this.id, this.sourceCurrency, this.targetCurrency, sourceAmount, this.targetAmount, this.payOut, this.rate, this.createdTime, this.fee, this.user, this.profile, this.rateType, this.rateExpirationTime, this.providedAmountType, this.status, this.expirationTime, this.notices, this.paymentOptions, this.formattedEstimatedDelivery);
    }

    public Quote updateTargetAmount(BigDecimal targetAmount) {
        return new Quote(this.id, this.sourceCurrency, this.targetCurrency, this.sourceAmount, targetAmount, this.payOut, this.rate, this.createdTime, this.fee, this.user, this.profile, this.rateType, this.rateExpirationTime, this.providedAmountType, this.status, this.expirationTime, this.notices, this.paymentOptions, this.formattedEstimatedDelivery);
    }

    public Quote updateFormattedEstimatedDelivery(String formattedEstimatedDelivery) {
        return new Quote(this.id, this.sourceCurrency, this.targetCurrency, this.sourceAmount, this.targetAmount, this.payOut, this.rate, this.createdTime, this.fee, this.user, this.profile, this.rateType, this.rateExpirationTime, this.providedAmountType, this.status, this.expirationTime, this.notices, this.paymentOptions, formattedEstimatedDelivery);
    }

    public Optional<PaymentOption> extractCorrectPaymentOption() {
        return this.paymentOptions.stream().filter(paymentOption -> BANK_TRANSFER.equalsIgnoreCase(paymentOption.getPayIn()) && this.payOut.equalsIgnoreCase(paymentOption.getPayOut())).findFirst();
    }

    public UUID getId() {
        return this.id;
    }

    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    public String getTargetCurrency() {
        return this.targetCurrency;
    }

    public BigDecimal getSourceAmount() {
        return this.sourceAmount;
    }

    public BigDecimal getTargetAmount() {
        return this.targetAmount;
    }

    public String getPayOut() {
        return this.payOut;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public LocalDateTime getCreatedTime() {
        return this.createdTime;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public Integer getUser() {
        return this.user;
    }

    public Integer getProfile() {
        return this.profile;
    }

    public String getRateType() {
        return this.rateType;
    }

    public LocalDateTime getRateExpirationTime() {
        return this.rateExpirationTime;
    }

    public String getProvidedAmountType() {
        return this.providedAmountType;
    }

    public String getStatus() {
        return this.status;
    }

    public LocalDateTime getExpirationTime() {
        return this.expirationTime;
    }

    public List<QuoteNotice> getNotices() {
        return this.notices;
    }

    public List<PaymentOption> getPaymentOptions() {
        return this.paymentOptions;
    }

    public String getFormattedEstimatedDelivery() {
        return this.formattedEstimatedDelivery;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Quote)) {
            return false;
        }
        Quote other = (Quote)o;
        Integer this$user = this.getUser();
        Integer other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Integer this$profile = this.getProfile();
        Integer other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !((Object)this$profile).equals(other$profile)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$sourceCurrency = this.getSourceCurrency();
        String other$sourceCurrency = other.getSourceCurrency();
        if (this$sourceCurrency == null ? other$sourceCurrency != null : !this$sourceCurrency.equals(other$sourceCurrency)) {
            return false;
        }
        String this$targetCurrency = this.getTargetCurrency();
        String other$targetCurrency = other.getTargetCurrency();
        if (this$targetCurrency == null ? other$targetCurrency != null : !this$targetCurrency.equals(other$targetCurrency)) {
            return false;
        }
        BigDecimal this$sourceAmount = this.getSourceAmount();
        BigDecimal other$sourceAmount = other.getSourceAmount();
        if (this$sourceAmount == null ? other$sourceAmount != null : !((Object)this$sourceAmount).equals(other$sourceAmount)) {
            return false;
        }
        BigDecimal this$targetAmount = this.getTargetAmount();
        BigDecimal other$targetAmount = other.getTargetAmount();
        if (this$targetAmount == null ? other$targetAmount != null : !((Object)this$targetAmount).equals(other$targetAmount)) {
            return false;
        }
        String this$payOut = this.getPayOut();
        String other$payOut = other.getPayOut();
        if (this$payOut == null ? other$payOut != null : !this$payOut.equals(other$payOut)) {
            return false;
        }
        BigDecimal this$rate = this.getRate();
        BigDecimal other$rate = other.getRate();
        if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
            return false;
        }
        LocalDateTime this$createdTime = this.getCreatedTime();
        LocalDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        BigDecimal this$fee = this.getFee();
        BigDecimal other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        String this$rateType = this.getRateType();
        String other$rateType = other.getRateType();
        if (this$rateType == null ? other$rateType != null : !this$rateType.equals(other$rateType)) {
            return false;
        }
        LocalDateTime this$rateExpirationTime = this.getRateExpirationTime();
        LocalDateTime other$rateExpirationTime = other.getRateExpirationTime();
        if (this$rateExpirationTime == null ? other$rateExpirationTime != null : !((Object)this$rateExpirationTime).equals(other$rateExpirationTime)) {
            return false;
        }
        String this$providedAmountType = this.getProvidedAmountType();
        String other$providedAmountType = other.getProvidedAmountType();
        if (this$providedAmountType == null ? other$providedAmountType != null : !this$providedAmountType.equals(other$providedAmountType)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        LocalDateTime this$expirationTime = this.getExpirationTime();
        LocalDateTime other$expirationTime = other.getExpirationTime();
        if (this$expirationTime == null ? other$expirationTime != null : !((Object)this$expirationTime).equals(other$expirationTime)) {
            return false;
        }
        List<QuoteNotice> this$notices = this.getNotices();
        List<QuoteNotice> other$notices = other.getNotices();
        if (this$notices == null ? other$notices != null : !((Object)this$notices).equals(other$notices)) {
            return false;
        }
        List<PaymentOption> this$paymentOptions = this.getPaymentOptions();
        List<PaymentOption> other$paymentOptions = other.getPaymentOptions();
        if (this$paymentOptions == null ? other$paymentOptions != null : !((Object)this$paymentOptions).equals(other$paymentOptions)) {
            return false;
        }
        String this$formattedEstimatedDelivery = this.getFormattedEstimatedDelivery();
        String other$formattedEstimatedDelivery = other.getFormattedEstimatedDelivery();
        return !(this$formattedEstimatedDelivery == null ? other$formattedEstimatedDelivery != null : !this$formattedEstimatedDelivery.equals(other$formattedEstimatedDelivery));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Integer $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : ((Object)$profile).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $sourceCurrency = this.getSourceCurrency();
        result = result * 59 + ($sourceCurrency == null ? 43 : $sourceCurrency.hashCode());
        String $targetCurrency = this.getTargetCurrency();
        result = result * 59 + ($targetCurrency == null ? 43 : $targetCurrency.hashCode());
        BigDecimal $sourceAmount = this.getSourceAmount();
        result = result * 59 + ($sourceAmount == null ? 43 : ((Object)$sourceAmount).hashCode());
        BigDecimal $targetAmount = this.getTargetAmount();
        result = result * 59 + ($targetAmount == null ? 43 : ((Object)$targetAmount).hashCode());
        String $payOut = this.getPayOut();
        result = result * 59 + ($payOut == null ? 43 : $payOut.hashCode());
        BigDecimal $rate = this.getRate();
        result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
        LocalDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        BigDecimal $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        String $rateType = this.getRateType();
        result = result * 59 + ($rateType == null ? 43 : $rateType.hashCode());
        LocalDateTime $rateExpirationTime = this.getRateExpirationTime();
        result = result * 59 + ($rateExpirationTime == null ? 43 : ((Object)$rateExpirationTime).hashCode());
        String $providedAmountType = this.getProvidedAmountType();
        result = result * 59 + ($providedAmountType == null ? 43 : $providedAmountType.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        LocalDateTime $expirationTime = this.getExpirationTime();
        result = result * 59 + ($expirationTime == null ? 43 : ((Object)$expirationTime).hashCode());
        List<QuoteNotice> $notices = this.getNotices();
        result = result * 59 + ($notices == null ? 43 : ((Object)$notices).hashCode());
        List<PaymentOption> $paymentOptions = this.getPaymentOptions();
        result = result * 59 + ($paymentOptions == null ? 43 : ((Object)$paymentOptions).hashCode());
        String $formattedEstimatedDelivery = this.getFormattedEstimatedDelivery();
        result = result * 59 + ($formattedEstimatedDelivery == null ? 43 : $formattedEstimatedDelivery.hashCode());
        return result;
    }

    public String toString() {
        return "Quote(id=" + String.valueOf(this.getId()) + ", sourceCurrency=" + this.getSourceCurrency() + ", targetCurrency=" + this.getTargetCurrency() + ", sourceAmount=" + String.valueOf(this.getSourceAmount()) + ", targetAmount=" + String.valueOf(this.getTargetAmount()) + ", payOut=" + this.getPayOut() + ", rate=" + String.valueOf(this.getRate()) + ", createdTime=" + String.valueOf(this.getCreatedTime()) + ", fee=" + String.valueOf(this.getFee()) + ", user=" + this.getUser() + ", profile=" + this.getProfile() + ", rateType=" + this.getRateType() + ", rateExpirationTime=" + String.valueOf(this.getRateExpirationTime()) + ", providedAmountType=" + this.getProvidedAmountType() + ", status=" + this.getStatus() + ", expirationTime=" + String.valueOf(this.getExpirationTime()) + ", notices=" + String.valueOf(this.getNotices()) + ", paymentOptions=" + String.valueOf(this.getPaymentOptions()) + ", formattedEstimatedDelivery=" + this.getFormattedEstimatedDelivery() + ")";
    }
}

