/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Objects;

public final class QuoteRequest {
    @NotNull
    private final String sourceCurrency;
    @NotNull
    private final String targetCurrency;
    private final BigDecimal sourceAmount;
    private final BigDecimal targetAmount;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"sourceCurrency", "targetCurrency", "sourceAmount", "targetAmount"})
    public QuoteRequest(@JsonProperty(value="sourceCurrency") String sourceCurrency, @JsonProperty(value="targetCurrency") String targetCurrency, @JsonProperty(value="sourceAmount") BigDecimal sourceAmount, @JsonProperty(value="targetAmount") BigDecimal targetAmount) {
        this.sourceCurrency = sourceCurrency;
        this.targetCurrency = targetCurrency;
        this.sourceAmount = sourceAmount;
        this.targetAmount = targetAmount;
    }

    boolean isAmountPresent() {
        return Objects.nonNull(this.sourceAmount) || Objects.nonNull(this.targetAmount);
    }

    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    public String getTargetCurrency() {
        return this.targetCurrency;
    }

    public BigDecimal getSourceAmount() {
        return this.sourceAmount;
    }

    public BigDecimal getTargetAmount() {
        return this.targetAmount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuoteRequest)) {
            return false;
        }
        QuoteRequest other = (QuoteRequest)o;
        String this$sourceCurrency = this.getSourceCurrency();
        String other$sourceCurrency = other.getSourceCurrency();
        if (this$sourceCurrency == null ? other$sourceCurrency != null : !this$sourceCurrency.equals(other$sourceCurrency)) {
            return false;
        }
        String this$targetCurrency = this.getTargetCurrency();
        String other$targetCurrency = other.getTargetCurrency();
        if (this$targetCurrency == null ? other$targetCurrency != null : !this$targetCurrency.equals(other$targetCurrency)) {
            return false;
        }
        BigDecimal this$sourceAmount = this.getSourceAmount();
        BigDecimal other$sourceAmount = other.getSourceAmount();
        if (this$sourceAmount == null ? other$sourceAmount != null : !((Object)this$sourceAmount).equals(other$sourceAmount)) {
            return false;
        }
        BigDecimal this$targetAmount = this.getTargetAmount();
        BigDecimal other$targetAmount = other.getTargetAmount();
        return !(this$targetAmount == null ? other$targetAmount != null : !((Object)this$targetAmount).equals(other$targetAmount));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sourceCurrency = this.getSourceCurrency();
        result = result * 59 + ($sourceCurrency == null ? 43 : $sourceCurrency.hashCode());
        String $targetCurrency = this.getTargetCurrency();
        result = result * 59 + ($targetCurrency == null ? 43 : $targetCurrency.hashCode());
        BigDecimal $sourceAmount = this.getSourceAmount();
        result = result * 59 + ($sourceAmount == null ? 43 : ((Object)$sourceAmount).hashCode());
        BigDecimal $targetAmount = this.getTargetAmount();
        result = result * 59 + ($targetAmount == null ? 43 : ((Object)$targetAmount).hashCode());
        return result;
    }

    public String toString() {
        return "QuoteRequest(sourceCurrency=" + this.getSourceCurrency() + ", targetCurrency=" + this.getTargetCurrency() + ", sourceAmount=" + String.valueOf(this.getSourceAmount()) + ", targetAmount=" + String.valueOf(this.getTargetAmount()) + ")";
    }
}

