/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.quote.client.impl;

import java.util.UUID;
import java.util.function.Function;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.client.BodyRequests;
import travel.wink.wise.partner.client.TransferWisePaths;
import travel.wink.wise.partner.client.params.ProfileId;
import travel.wink.wise.partner.client.params.TargetAccount;
import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import travel.wink.wise.partner.quote.api.CreateAnonymousQuote;
import travel.wink.wise.partner.quote.api.CreateQuote;
import travel.wink.wise.partner.quote.api.Quote;
import travel.wink.wise.partner.quote.api.WiseQuoteResponse;
import travel.wink.wise.partner.quote.client.WiseQuoteClient;

public class WiseQuoteClientImpl
implements WiseQuoteClient {
    private static final MediaType MERGE_PATCH_JSON = MediaType.valueOf((String)"application/merge-patch+json");
    private final WebClient client;
    private final Function<WiseQuoteResponse, Quote> twResponseToQuote = twQuoteResponse -> new Quote(twQuoteResponse.getId(), twQuoteResponse.getSourceCurrency(), twQuoteResponse.getTargetCurrency(), twQuoteResponse.getSourceAmount(), twQuoteResponse.getTargetAmount(), twQuoteResponse.getPayOut(), twQuoteResponse.getRate(), twQuoteResponse.getCreatedTime(), twQuoteResponse.getFee(), twQuoteResponse.getUser(), twQuoteResponse.getProfile(), twQuoteResponse.getRateType(), twQuoteResponse.getRateExpirationTime(), twQuoteResponse.getProvidedAmountType(), twQuoteResponse.getStatus(), twQuoteResponse.getExpirationTime(), twQuoteResponse.getNotices(), twQuoteResponse.getPaymentOptions(), null);

    @Override
    public Mono<Quote> createAnonymousQuote(CreateAnonymousQuote createAnonymousQuote) {
        return ((WebClient.RequestBodySpec)this.client.post().uri("/v2/quotes/", new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)createAnonymousQuote).retrieve().bodyToMono(WiseQuoteResponse.class).map(this.twResponseToQuote);
    }

    @Override
    public Mono<Quote> createQuote(WiseUserTokens twUserTokens, CreateQuote createQuote) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri("/v2/quotes/", new Object[0])).header("Authorization", new String[]{twUserTokens.bearer()})).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)createQuote).retrieve().bodyToMono(WiseQuoteResponse.class).map(this.twResponseToQuote);
    }

    @Override
    public Mono<Quote> updateQuote(WiseUserTokens twUserTokens, UUID quoteId, Long profileId, Long recipientId) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.patch().uri(TransferWisePaths.quotesPathV2(quoteId), new Object[0])).header("Authorization", new String[]{twUserTokens.bearer()})).contentType(MERGE_PATCH_JSON).body(BodyRequests.forQuoteUpdate(new ProfileId(profileId), new TargetAccount(recipientId))).retrieve().bodyToMono(WiseQuoteResponse.class).map(this.twResponseToQuote);
    }

    @Override
    public Mono<Quote> getQuote(WiseUserTokens twUserTokens, UUID quoteId) {
        return this.client.get().uri(TransferWisePaths.quotesPathV2(quoteId), new Object[0]).header("Authorization", new String[]{twUserTokens.bearer()}).retrieve().bodyToMono(WiseQuoteResponse.class).map(this.twResponseToQuote);
    }

    public WiseQuoteClientImpl(WebClient client) {
        this.client = client;
    }
}

