/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.recipient.client.impl;

import java.util.UUID;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.client.TransferWisePaths;
import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import travel.wink.wise.partner.recipient.api.Recipient;
import travel.wink.wise.partner.recipient.api.WiseRecipientsContent;
import travel.wink.wise.partner.recipient.client.WiseRecipientClient;

public class WiseRecipientClientImpl
implements WiseRecipientClient {
    private final WebClient client;

    @Override
    public Mono<Recipient> getRecipient(WiseUserTokens twUserTokens, Long recipientId) {
        return this.client.get().uri(TransferWisePaths.recipientByIdPath(recipientId), new Object[0]).header("Authorization", new String[]{twUserTokens.bearer()}).retrieve().bodyToMono(Recipient.class);
    }

    @Override
    public Flux<Recipient> getAllRecipients(WiseUserTokens twUserTokens, Long twProfileId, String currencyCode) {
        return this.client.get().uri(uriBuilder -> {
            uriBuilder = uriBuilder.path("/v2/accounts").queryParam("profile", new Object[]{twProfileId});
            if (currencyCode != null) {
                uriBuilder = uriBuilder.queryParam("currency", new Object[]{currencyCode});
            }
            return uriBuilder.build(new Object[0]);
        }).header("Authorization", new String[]{twUserTokens.bearer()}).retrieve().bodyToFlux(WiseRecipientsContent.class).flatMap(content -> Flux.fromIterable(content.getRecipients()));
    }

    @Override
    public Mono<String> create(WiseUserTokens twUserTokens, String requestBody) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri("/v1/accounts", new Object[0])).header("Authorization", new String[]{twUserTokens.bearer()})).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)requestBody).retrieve().bodyToMono(String.class);
    }

    @Override
    public Mono<String> getRequirements(WiseUserTokens twUserTokens, UUID quoteId) {
        return this.client.get().uri(TransferWisePaths.recipientRequirementsPath(quoteId), new Object[0]).header("Authorization", new String[]{twUserTokens.bearer()}).retrieve().bodyToMono(String.class);
    }

    @Override
    public Mono<String> createRequirements(WiseUserTokens twUserTokens, UUID quoteId, String requestBody) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri(TransferWisePaths.recipientRequirementsPath(quoteId), new Object[0])).header("Authorization", new String[]{twUserTokens.bearer()})).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)requestBody).retrieve().bodyToMono(String.class);
    }

    public WiseRecipientClientImpl(WebClient client) {
        this.client = client;
    }
}

