/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import travel.wink.wise.partner.transfer.api.CustomerTransferStatus;

public final class CustomerTransfer {
    private final Long id;
    private final Long customerId;
    private final Long recipientId;
    private final UUID quoteId;
    private final String reference;
    private final BigDecimal rate;
    private final LocalDateTime created;
    private final String sourceCurrency;
    private final BigDecimal sourceValue;
    private final String targetCurrency;
    private final BigDecimal targetValue;
    private final UUID customerTransactionId;
    private final String recipientName;
    private final BigDecimal fee;
    private final String accountSummary;
    private final List<CustomerTransferStatus> transferStatuses;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"id", "customerId", "recipientId", "quoteId", "reference", "rate", "created", "sourceCurrency", "sourceValue", "targetCurrency", "targetValue", "customerTransactionId", "recipientName", "fee", "accountSummary", "transferStatuses"})
    public CustomerTransfer(@JsonProperty(value="id") Long id, @JsonProperty(value="customerId") Long customerId, @JsonProperty(value="recipientId") Long recipientId, @JsonProperty(value="quoteId") UUID quoteId, @JsonProperty(value="reference") String reference, @JsonProperty(value="rate") BigDecimal rate, @JsonProperty(value="created") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime created, @JsonProperty(value="sourceCurrency") String sourceCurrency, @JsonProperty(value="sourceValue") BigDecimal sourceValue, @JsonProperty(value="targetCurrency") String targetCurrency, @JsonProperty(value="targetValue") BigDecimal targetValue, @JsonProperty(value="customerTransactionId") UUID customerTransactionId, @JsonProperty(value="recipientName") String recipientName, @JsonProperty(value="fee") BigDecimal fee, @JsonProperty(value="accountSummary") String accountSummary, @JsonProperty(value="transferStatuses") List<CustomerTransferStatus> transferStatuses) {
        this.id = id;
        this.customerId = customerId;
        this.recipientId = recipientId;
        this.quoteId = quoteId;
        this.reference = reference;
        this.rate = rate;
        this.created = created;
        this.sourceCurrency = sourceCurrency;
        this.sourceValue = sourceValue;
        this.targetCurrency = targetCurrency;
        this.targetValue = targetValue;
        this.customerTransactionId = customerTransactionId;
        this.recipientName = recipientName;
        this.fee = fee;
        this.accountSummary = accountSummary;
        this.transferStatuses = CollectionUtils.isNotEmpty(transferStatuses) ? transferStatuses.stream().sorted(Comparator.comparing(CustomerTransferStatus::getEventTime)).toList() : Collections.emptyList();
    }

    public Long getId() {
        return this.id;
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public Long getRecipientId() {
        return this.recipientId;
    }

    public UUID getQuoteId() {
        return this.quoteId;
    }

    public String getReference() {
        return this.reference;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    public BigDecimal getSourceValue() {
        return this.sourceValue;
    }

    public String getTargetCurrency() {
        return this.targetCurrency;
    }

    public BigDecimal getTargetValue() {
        return this.targetValue;
    }

    public UUID getCustomerTransactionId() {
        return this.customerTransactionId;
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public String getAccountSummary() {
        return this.accountSummary;
    }

    public List<CustomerTransferStatus> getTransferStatuses() {
        return this.transferStatuses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerTransfer)) {
            return false;
        }
        CustomerTransfer other = (CustomerTransfer)o;
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$customerId = this.getCustomerId();
        Long other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        Long this$recipientId = this.getRecipientId();
        Long other$recipientId = other.getRecipientId();
        if (this$recipientId == null ? other$recipientId != null : !((Object)this$recipientId).equals(other$recipientId)) {
            return false;
        }
        UUID this$quoteId = this.getQuoteId();
        UUID other$quoteId = other.getQuoteId();
        if (this$quoteId == null ? other$quoteId != null : !((Object)this$quoteId).equals(other$quoteId)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        BigDecimal this$rate = this.getRate();
        BigDecimal other$rate = other.getRate();
        if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
            return false;
        }
        LocalDateTime this$created = this.getCreated();
        LocalDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$sourceCurrency = this.getSourceCurrency();
        String other$sourceCurrency = other.getSourceCurrency();
        if (this$sourceCurrency == null ? other$sourceCurrency != null : !this$sourceCurrency.equals(other$sourceCurrency)) {
            return false;
        }
        BigDecimal this$sourceValue = this.getSourceValue();
        BigDecimal other$sourceValue = other.getSourceValue();
        if (this$sourceValue == null ? other$sourceValue != null : !((Object)this$sourceValue).equals(other$sourceValue)) {
            return false;
        }
        String this$targetCurrency = this.getTargetCurrency();
        String other$targetCurrency = other.getTargetCurrency();
        if (this$targetCurrency == null ? other$targetCurrency != null : !this$targetCurrency.equals(other$targetCurrency)) {
            return false;
        }
        BigDecimal this$targetValue = this.getTargetValue();
        BigDecimal other$targetValue = other.getTargetValue();
        if (this$targetValue == null ? other$targetValue != null : !((Object)this$targetValue).equals(other$targetValue)) {
            return false;
        }
        UUID this$customerTransactionId = this.getCustomerTransactionId();
        UUID other$customerTransactionId = other.getCustomerTransactionId();
        if (this$customerTransactionId == null ? other$customerTransactionId != null : !((Object)this$customerTransactionId).equals(other$customerTransactionId)) {
            return false;
        }
        String this$recipientName = this.getRecipientName();
        String other$recipientName = other.getRecipientName();
        if (this$recipientName == null ? other$recipientName != null : !this$recipientName.equals(other$recipientName)) {
            return false;
        }
        BigDecimal this$fee = this.getFee();
        BigDecimal other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        String this$accountSummary = this.getAccountSummary();
        String other$accountSummary = other.getAccountSummary();
        if (this$accountSummary == null ? other$accountSummary != null : !this$accountSummary.equals(other$accountSummary)) {
            return false;
        }
        List<CustomerTransferStatus> this$transferStatuses = this.getTransferStatuses();
        List<CustomerTransferStatus> other$transferStatuses = other.getTransferStatuses();
        return !(this$transferStatuses == null ? other$transferStatuses != null : !((Object)this$transferStatuses).equals(other$transferStatuses));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        Long $recipientId = this.getRecipientId();
        result = result * 59 + ($recipientId == null ? 43 : ((Object)$recipientId).hashCode());
        UUID $quoteId = this.getQuoteId();
        result = result * 59 + ($quoteId == null ? 43 : ((Object)$quoteId).hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        BigDecimal $rate = this.getRate();
        result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
        LocalDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $sourceCurrency = this.getSourceCurrency();
        result = result * 59 + ($sourceCurrency == null ? 43 : $sourceCurrency.hashCode());
        BigDecimal $sourceValue = this.getSourceValue();
        result = result * 59 + ($sourceValue == null ? 43 : ((Object)$sourceValue).hashCode());
        String $targetCurrency = this.getTargetCurrency();
        result = result * 59 + ($targetCurrency == null ? 43 : $targetCurrency.hashCode());
        BigDecimal $targetValue = this.getTargetValue();
        result = result * 59 + ($targetValue == null ? 43 : ((Object)$targetValue).hashCode());
        UUID $customerTransactionId = this.getCustomerTransactionId();
        result = result * 59 + ($customerTransactionId == null ? 43 : ((Object)$customerTransactionId).hashCode());
        String $recipientName = this.getRecipientName();
        result = result * 59 + ($recipientName == null ? 43 : $recipientName.hashCode());
        BigDecimal $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        String $accountSummary = this.getAccountSummary();
        result = result * 59 + ($accountSummary == null ? 43 : $accountSummary.hashCode());
        List<CustomerTransferStatus> $transferStatuses = this.getTransferStatuses();
        result = result * 59 + ($transferStatuses == null ? 43 : ((Object)$transferStatuses).hashCode());
        return result;
    }

    public String toString() {
        return "CustomerTransfer(id=" + this.getId() + ", customerId=" + this.getCustomerId() + ", recipientId=" + this.getRecipientId() + ", quoteId=" + String.valueOf(this.getQuoteId()) + ", reference=" + this.getReference() + ", rate=" + String.valueOf(this.getRate()) + ", created=" + String.valueOf(this.getCreated()) + ", sourceCurrency=" + this.getSourceCurrency() + ", sourceValue=" + String.valueOf(this.getSourceValue()) + ", targetCurrency=" + this.getTargetCurrency() + ", targetValue=" + String.valueOf(this.getTargetValue()) + ", customerTransactionId=" + String.valueOf(this.getCustomerTransactionId()) + ", recipientName=" + this.getRecipientName() + ", fee=" + String.valueOf(this.getFee()) + ", accountSummary=" + this.getAccountSummary() + ", transferStatuses=" + String.valueOf(this.getTransferStatuses()) + ")";
    }
}

