/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.UUID;
import travel.wink.wise.partner.transfer.api.TransferRequestDetails;

public final class TransferRequest {
    private final Long targetAccount;
    private final UUID quoteUuid;
    private final UUID customerTransactionId;
    private final TransferRequestDetails details;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"targetAccount", "quoteUuid", "customerTransactionId", "details"})
    public TransferRequest(@JsonProperty(value="targetAccount") Long targetAccount, @JsonProperty(value="quoteUuid") UUID quoteUuid, @JsonProperty(value="customerTransactionId") UUID customerTransactionId, @JsonProperty(value="details") TransferRequestDetails details) {
        this.targetAccount = targetAccount;
        this.quoteUuid = quoteUuid;
        this.customerTransactionId = customerTransactionId;
        this.details = details;
    }

    public static TransferRequest of(Long targetAccount, UUID quoteUuid) {
        return new TransferRequest(targetAccount, quoteUuid, null, null);
    }

    public TransferRequest updateCustomerTransactionId(UUID customerTransactionId) {
        return new TransferRequest(this.targetAccount, this.quoteUuid, customerTransactionId, this.details);
    }

    public Long getTargetAccount() {
        return this.targetAccount;
    }

    public UUID getQuoteUuid() {
        return this.quoteUuid;
    }

    public UUID getCustomerTransactionId() {
        return this.customerTransactionId;
    }

    public TransferRequestDetails getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferRequest)) {
            return false;
        }
        TransferRequest other = (TransferRequest)o;
        Long this$targetAccount = this.getTargetAccount();
        Long other$targetAccount = other.getTargetAccount();
        if (this$targetAccount == null ? other$targetAccount != null : !((Object)this$targetAccount).equals(other$targetAccount)) {
            return false;
        }
        UUID this$quoteUuid = this.getQuoteUuid();
        UUID other$quoteUuid = other.getQuoteUuid();
        if (this$quoteUuid == null ? other$quoteUuid != null : !((Object)this$quoteUuid).equals(other$quoteUuid)) {
            return false;
        }
        UUID this$customerTransactionId = this.getCustomerTransactionId();
        UUID other$customerTransactionId = other.getCustomerTransactionId();
        if (this$customerTransactionId == null ? other$customerTransactionId != null : !((Object)this$customerTransactionId).equals(other$customerTransactionId)) {
            return false;
        }
        TransferRequestDetails this$details = this.getDetails();
        TransferRequestDetails other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $targetAccount = this.getTargetAccount();
        result = result * 59 + ($targetAccount == null ? 43 : ((Object)$targetAccount).hashCode());
        UUID $quoteUuid = this.getQuoteUuid();
        result = result * 59 + ($quoteUuid == null ? 43 : ((Object)$quoteUuid).hashCode());
        UUID $customerTransactionId = this.getCustomerTransactionId();
        result = result * 59 + ($customerTransactionId == null ? 43 : ((Object)$customerTransactionId).hashCode());
        TransferRequestDetails $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public String toString() {
        return "TransferRequest(targetAccount=" + this.getTargetAccount() + ", quoteUuid=" + String.valueOf(this.getQuoteUuid()) + ", customerTransactionId=" + String.valueOf(this.getCustomerTransactionId()) + ", details=" + String.valueOf(this.getDetails()) + ")";
    }
}

