/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import travel.wink.wise.partner.transfer.api.CustomerTransferStatus;
import travel.wink.wise.partner.transfer.api.TransferStatusChangeData;

public final class TransferStatusChangeEvent {
    private final TransferStatusChangeData data;
    private final String subscriptionId;
    private final String eventType;
    private final String schemaVersion;
    private final ZonedDateTime sentAt;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"data", "subscriptionId", "eventType", "schemaVersion", "sentAt"})
    public TransferStatusChangeEvent(@JsonProperty(value="") TransferStatusChangeData data, @JsonProperty(value="subscription_id") String subscriptionId, @JsonProperty(value="event_type") String eventType, @JsonProperty(value="schema_version") String schemaVersion, @JsonProperty(value="sent_at") ZonedDateTime sentAt) {
        this.data = data;
        this.subscriptionId = subscriptionId;
        this.eventType = eventType;
        this.schemaVersion = schemaVersion;
        this.sentAt = sentAt;
    }

    public CustomerTransferStatus toCustomerTransferStatus() {
        return new CustomerTransferStatus(this.getData().getResource().getId(), this.getData().getCurrentState(), this.getData().getOccurredAt().toLocalDateTime());
    }

    public TransferStatusChangeData getData() {
        return this.data;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public ZonedDateTime getSentAt() {
        return this.sentAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferStatusChangeEvent)) {
            return false;
        }
        TransferStatusChangeEvent other = (TransferStatusChangeEvent)o;
        TransferStatusChangeData this$data = this.getData();
        TransferStatusChangeData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$subscriptionId = this.getSubscriptionId();
        String other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !this$subscriptionId.equals(other$subscriptionId)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$schemaVersion = this.getSchemaVersion();
        String other$schemaVersion = other.getSchemaVersion();
        if (this$schemaVersion == null ? other$schemaVersion != null : !this$schemaVersion.equals(other$schemaVersion)) {
            return false;
        }
        ZonedDateTime this$sentAt = this.getSentAt();
        ZonedDateTime other$sentAt = other.getSentAt();
        return !(this$sentAt == null ? other$sentAt != null : !((Object)this$sentAt).equals(other$sentAt));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransferStatusChangeData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : $subscriptionId.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $schemaVersion = this.getSchemaVersion();
        result = result * 59 + ($schemaVersion == null ? 43 : $schemaVersion.hashCode());
        ZonedDateTime $sentAt = this.getSentAt();
        result = result * 59 + ($sentAt == null ? 43 : ((Object)$sentAt).hashCode());
        return result;
    }

    public String toString() {
        return "TransferStatusChangeEvent(data=" + String.valueOf(this.getData()) + ", subscriptionId=" + this.getSubscriptionId() + ", eventType=" + this.getEventType() + ", schemaVersion=" + this.getSchemaVersion() + ", sentAt=" + String.valueOf(this.getSentAt()) + ")";
    }
}

