/*
 * Decompiled with CFR 0.152.
 */
package ug.sparkpl.momoapi.network.collections;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.joda.time.DateTime;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;
import ug.sparkpl.momoapi.models.AccessToken;
import ug.sparkpl.momoapi.models.Balance;
import ug.sparkpl.momoapi.models.RequestToPay;
import ug.sparkpl.momoapi.models.Transaction;
import ug.sparkpl.momoapi.network.RequestOptions;
import ug.sparkpl.momoapi.network.collections.CollectionSession;
import ug.sparkpl.momoapi.network.collections.CollectionsApiService;
import ug.sparkpl.momoapi.network.collections.CollectionsAuthorizationInterceptor;
import ug.sparkpl.momoapi.utils.DateTimeTypeConverter;

public class CollectionsClient {
    RequestOptions opts;
    Gson gson;
    private CollectionSession session;
    private CollectionsApiService apiService;
    private OkHttpClient httpClient;
    private Retrofit retrofitClient;
    private Retrofit client;

    public CollectionsClient(RequestOptions opts) {
        this.opts = opts;
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeConverter()).create();
        this.session = new CollectionSession();
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder okhttpbuilder = new OkHttpClient.Builder();
        okhttpbuilder.addInterceptor((Interceptor)new CollectionsAuthorizationInterceptor(this.session, this.opts));
        okhttpbuilder.addInterceptor((Interceptor)httpLoggingInterceptor);
        okhttpbuilder.connectTimeout(60L, TimeUnit.SECONDS);
        okhttpbuilder.readTimeout(60L, TimeUnit.SECONDS);
        okhttpbuilder.writeTimeout(60L, TimeUnit.SECONDS);
        this.httpClient = okhttpbuilder.build();
        this.retrofitClient = new Retrofit.Builder().client(this.httpClient).baseUrl(opts.getBaseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.gson)).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).build();
        this.apiService = (CollectionsApiService)this.retrofitClient.create(CollectionsApiService.class);
    }

    public AccessToken getToken() throws IOException {
        String credentials = Credentials.basic((String)this.opts.getCollectionUserId(), (String)this.opts.getCollectionApiSecret());
        Response token = this.apiService.getToken(credentials, this.opts.getCollectionPrimaryKey()).execute();
        return (AccessToken)token.body();
    }

    public Balance getBalance() throws IOException {
        Response balance = this.apiService.getBalance().execute();
        return (Balance)balance.body();
    }

    public Transaction getTransaction(String ref) throws IOException {
        Response transaction = this.apiService.getTransactionStatus(ref).execute();
        return (Transaction)transaction.body();
    }

    public String requestToPay(String mobile, String amount, String externalId, String payeeNote, String payerMessage, String currency) throws IOException {
        RequestToPay rbody = new RequestToPay(mobile, amount, externalId, payeeNote, payerMessage, currency);
        String ref = UUID.randomUUID().toString();
        this.apiService.requestToPay(rbody, ref).execute();
        return ref;
    }

    public String requestToPay(HashMap<String, String> opts) throws IOException {
        RequestToPay rbody = new RequestToPay(opts.get("mobile"), opts.get("amount"), opts.get("externalId"), opts.get("payeeNote"), opts.get("payerMessage"), opts.getOrDefault("currency", this.opts.getCurrency()));
        String ref = UUID.randomUUID().toString();
        this.apiService.requestToPay(rbody, ref).execute();
        return ref;
    }
}

