/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import uno.anahata.mapacho.client.LoadingStage;
import uno.anahata.mapacho.client.Mapacho;
import uno.anahata.mapacho.client.deploy.Deployer;

public class JavaFxDeployer
extends Application {
    private LoadingStage scene;
    private static JavaFxDeployer instance;
    private static List<String> startupArs;
    private static boolean toolkitInitialized;
    private static List<Runnable> deferredFxThreadRunnables;
    private static final Object initLock;

    public static List<String> getStartupArguments() {
        return JavaFxDeployer.getInstance().getParameters().getRaw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAsap(Runnable r) {
        Object object = initLock;
        synchronized (object) {
            if (!toolkitInitialized) {
                Mapacho.log("Deferring runnable " + r);
                deferredFxThreadRunnables.add(r);
            } else if (Platform.isFxApplicationThread()) {
                r.run();
            } else {
                Platform.runLater((Runnable)r);
            }
        }
    }

    public void init() throws Exception {
        Mapacho.log("JavaFXDeployer init()");
        instance = this;
    }

    public void start(Stage stage) throws Exception {
        Mapacho.log("JavaFXDeployer start()");
        URL splash = Mapacho.getSplashScreenURL();
        Image splashImage = new Image(splash.toString(), true);
        this.scene = new LoadingStage(stage, splashImage);
        stage.show();
        Mapacho.log("toolkitInitialized");
        Platform.runLater(() -> {
            Object object = initLock;
            synchronized (object) {
                toolkitInitialized = true;
                for (Runnable r : deferredFxThreadRunnables) {
                    Mapacho.log("Running deferredRunnable " + r);
                    r.run();
                    Mapacho.log("deferredRunnable " + r + " completed");
                }
            }
        });
    }

    public void stop() throws Exception {
        Mapacho.log("in stop() hiding stage and firing countdown:");
        if (this.scene != null && this.scene.getStage() != null) {
            this.scene.getStage().hide();
            Mapacho.log("in stop() called stage.hide");
        }
        Mapacho.fireCountdown();
        Mapacho.log("in stop() countdown fired");
    }

    public static void main(String[] args) {
        Mapacho.log("JavaFXDeployer main(String[]) args");
        JavaFxDeployer.launch((String[])args);
        Mapacho.log("JavaFXDeployer main(String[]) args exited");
    }

    public LoadingStage getScene() {
        return this.scene;
    }

    public static JavaFxDeployer getInstance() {
        return instance;
    }

    public static List<String> getStartupArs() {
        return startupArs;
    }

    static {
        Mapacho.log("JavaFXDeployer static");
        new Deployer().start();
        Mapacho.log("new Deployer().start()");
        toolkitInitialized = false;
        deferredFxThreadRunnables = new ArrayList<Runnable>();
        initLock = new Object();
    }
}

