/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client;

import java.awt.Rectangle;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.application.Preloader;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import uno.anahata.mapacho.client.Mapacho;
import uno.anahata.mapacho.client.ProgressBarWithLabel;

public class LoadingStage {
    public static final long START;
    private VBox root;
    private VBox progressBars;
    private TextArea log;
    private ImageView splashImageView;
    private Stage stage;
    private Scene scene;
    private static LoadingStage instance;
    private static List<String> startupArs;
    private Rectangle splashBounds;
    private ProgressBarWithLabel simpleProgressBar;
    private static final float CENTER_ON_SCREEN_X_FRACTION = 0.5f;
    private static final float CENTER_ON_SCREEN_Y_FRACTION = 0.5f;

    public LoadingStage(Stage stage, Image splashImage) throws Exception {
        Mapacho.log("LoadingStage constructor, splashImage = " + splashImage + " stage=" + stage);
        this.stage = stage;
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setResizable(false);
        stage.setTitle("Launching");
        this.root = new VBox();
        this.root.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.root.setFillWidth(true);
        this.splashImageView = new ImageView(splashImage);
        splashImage.widthProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                LoadingStage.this.calculateBounds();
            }
        });
        splashImage.heightProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                LoadingStage.this.calculateBounds();
            }
        });
        this.root.getChildren().add((Object)this.splashImageView);
        this.progressBars = new VBox();
        this.progressBars.prefWidthProperty().bind((ObservableValue)this.splashImageView.fitWidthProperty());
        this.progressBars.maxWidthProperty().bind((ObservableValue)this.splashImageView.fitWidthProperty());
        this.progressBars.minWidthProperty().bind((ObservableValue)this.splashImageView.fitWidthProperty());
        this.progressBars.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.progressBars.setFillWidth(true);
        this.updateMessage("Initializing Mapacho");
        this.root.getChildren().add((Object)this.progressBars);
        this.scene = new Scene((Parent)this.root);
        this.scene.setFill((Paint)Color.TRANSPARENT);
        stage.setScene(this.scene);
        stage.centerOnScreen();
        stage.show();
        this.root.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                LoadingStage.this.adjustStage();
            }
        });
        this.scene.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                LoadingStage.this.adjustStage();
            }
        });
        instance = this;
    }

    public void adjustStage() {
        this.stage.sizeToScene();
        if (this.splashBounds != null) {
            this.stage.setX(this.splashBounds.getX());
            this.stage.setY(this.splashBounds.getY());
            this.stage.setWidth(this.splashBounds.getWidth());
        } else {
            Mapacho.log("[WARN] No splash bounds during stageToSceneSize()");
        }
    }

    public ProgressBarWithLabel createProgressBar() {
        ProgressBarWithLabel ret = new ProgressBarWithLabel();
        ret.init(this);
        return ret;
    }

    public boolean handleErrorNotification(Preloader.ErrorNotification info) {
        this.updateMessage(info.toString());
        return false;
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification info) {
        if (info instanceof MessageNotification) {
            this.updateMessage(info.toString());
        } else if (info instanceof StateNotification) {
            Mapacho.log(this.getClass().getName() + "-" + info);
            StateNotification state = (StateNotification)info;
            FadeTransition ft = new FadeTransition(Duration.seconds((double)1.0), (Node)this.scene.getRoot());
            ft.setFromValue(1.0);
            ft.setToValue(0.0);
            if (state != StateNotification.HIDE) {
                if (state == StateNotification.SHOW) {
                    ft.setFromValue(0.0);
                    ft.setToValue(1.0);
                } else if (state == StateNotification.DISPOSE) {
                    this.updateMessage("Hiding Preloader stage on DISPOSE notification");
                    ft.setOnFinished(e -> this.stage.hide());
                }
            }
            ft.play();
        }
    }

    public void handleProgressNotification(Preloader.ProgressNotification info) {
        this.updateMessage("Progress: " + info.getProgress());
    }

    public void handleStateChangeNotification(Preloader.StateChangeNotification evt) {
        this.updateMessage(evt.getType().toString());
    }

    public void updateMessage(String m) {
        Mapacho.log(this.getClass().getName() + "-" + m);
        if (this.simpleProgressBar == null) {
            this.simpleProgressBar = this.createProgressBar();
            this.simpleProgressBar.getProgressBar().setProgress(-1.0);
        }
        this.simpleProgressBar.getLabel().setText(m);
    }

    private void calculateBounds() {
        double realWidh = this.splashImageView.getImage().getWidth();
        double realHeight = this.splashImageView.getImage().getHeight();
        if (realWidh > 1.0 && realHeight > 1.0) {
            Rectangle2D bounds = Screen.getPrimary().getBounds();
            double centerX = bounds.getMinX() + (bounds.getWidth() - realWidh) * 0.5;
            double centerY = bounds.getMinY() + (bounds.getHeight() - realHeight) * 0.5;
            this.splashBounds = new Rectangle((int)centerX, (int)centerY, (int)realWidh, (int)realHeight);
            this.splashImageView.setFitWidth(realWidh);
            Mapacho.log("Calculated bounds" + this.splashBounds);
            this.adjustStage();
        }
    }

    public VBox getRoot() {
        return this.root;
    }

    public VBox getProgressBars() {
        return this.progressBars;
    }

    public TextArea getLog() {
        return this.log;
    }

    public ImageView getSplashImageView() {
        return this.splashImageView;
    }

    public Rectangle getSplashBounds() {
        return this.splashBounds;
    }

    public ProgressBarWithLabel getSimpleProgressBar() {
        return this.simpleProgressBar;
    }

    public Stage getStage() {
        return this.stage;
    }

    public Scene getScene() {
        return this.scene;
    }

    public static LoadingStage getInstance() {
        return instance;
    }

    public static List<String> getStartupArs() {
        return startupArs;
    }

    static {
        Mapacho.log("Main static");
        START = System.currentTimeMillis();
    }

    public static enum StateNotification implements Preloader.PreloaderNotification,
    Serializable
    {
        SHOW,
        HIDE,
        DISPOSE;

    }

    public static class MessageNotification
    implements Preloader.PreloaderNotification,
    Serializable {
        String message;

        public String toString() {
            return this.message;
        }

        @ConstructorProperties(value={"message"})
        public MessageNotification(String message) {
            this.message = message;
        }
    }
}

