/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client;

import java.awt.SplashScreen;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.jnlp.ServiceManager;
import uno.anahata.mapacho.client.deploy.Repo;

public class Mapacho {
    private static final long STARTUP = System.currentTimeMillis();
    private static URL codeBase;
    private static URL context;
    private static boolean jws;
    private static PrintStream log;

    public static void log(String message) {
        long ts = System.currentTimeMillis() - STARTUP;
        String msg = ts + " ms. [" + Thread.currentThread().getName() + "] " + message + " - " + DateFormat.getTimeInstance(1).format(new Date());
        System.out.println(msg);
        log.println(msg);
    }

    public static String getJnlpFile() throws Exception {
        return Mapacho.getDescriptorId() + ".jnlp";
    }

    public static String getDescriptorId() {
        return Mapacho.getProperty("mapacho.descriptor");
    }

    public static URL getSplashScreenURL() throws MalformedURLException {
        return new URL(Mapacho.getSplashString());
    }

    public static String getDescriptorTimestamp() {
        return Mapacho.getProperty("mapacho.descriptor.timestamp");
    }

    private static String getCodeBaseString() {
        return Mapacho.getProperty("mapacho.codebase");
    }

    public static String getSplashString() {
        return Mapacho.getProperty("mapacho.splash");
    }

    public static String getPreloaderPort() {
        return Mapacho.getProperty("mapacho.preloader.port");
    }

    public static String getContextString() {
        return Mapacho.getProperty("mapacho.context");
    }

    private static boolean isJavaWebStart() {
        try {
            Class.forName("javax.jnlp.ServiceManager");
            return ServiceManager.getServiceNames() != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String getProperty(String prop) {
        if (jws) {
            prop = "jnlp." + prop;
        }
        return System.getProperty(prop);
    }

    public static void fireCountdown() {
        Thread t = new Thread(){

            @Override
            public void run() {
                Mapacho.log("Mapacho exiting in 60 seconds");
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                Mapacho.log("System.exit(0)");
                System.exit(0);
            }
        };
        t.setName("MapachoCountDownThread");
        t.setDaemon(false);
        Mapacho.log("Starting countdown thread");
        t.start();
        Mapacho.log("Countdown thread started");
    }

    public static URL getCodeBase() {
        return codeBase;
    }

    public static URL getContext() {
        return context;
    }

    public static boolean isJws() {
        return jws;
    }

    static {
        try {
            log = new PrintStream(new FileOutputStream(Repo.LOG_FILE));
            Mapacho.log("getting codebase, context, jws, splash screen= " + SplashScreen.getSplashScreen());
            jws = Mapacho.isJavaWebStart();
            codeBase = new URL(Mapacho.getCodeBaseString());
            context = new URL(Mapacho.getContextString());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new RuntimeException(e);
        }
        Mapacho.log("codebase=" + codeBase);
        Mapacho.log("context=" + context);
        Mapacho.log("jws=" + jws);
    }
}

