/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SplashScreen;
import java.net.URL;
import javax.jnlp.DownloadServiceListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import uno.anahata.mapacho.client.Mapacho;

public class MapachoDownloadServiceListener
implements DownloadServiceListener {
    private static MapachoDownloadServiceListener instance;
    private JFrame frame;
    private JProgressBar progressBar = null;

    public MapachoDownloadServiceListener() {
        MapachoDownloadServiceListener.log("JWS Instance Constructor:");
        instance = this;
        try {
            SwingUtilities.invokeLater(() -> this.createUI());
        }
        catch (Exception e) {
            e.printStackTrace();
            MapachoDownloadServiceListener.log("Error instantiating JWS instance " + e);
        }
    }

    private void createUI() {
        MapachoDownloadServiceListener.log("Creating UI");
        String osName = System.getProperty("os.name");
        if (osName.contains("mac") || !osName.contains("darwin")) {
            // empty if block
        }
        JPanel top = this.createComponents();
        MapachoDownloadServiceListener.log("UI Components created");
        this.frame = new JFrame();
        this.frame.getContentPane().add((Component)top, "Center");
        this.frame.setUndecorated(true);
        this.frame.setBackground(Color.WHITE);
        this.frame.pack();
        this.frame.setMinimumSize(new Dimension(290, 15));
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        SwingUtilities.invokeLater(() -> {
            top.add((Component)this.progressBar, "South");
            this.frame.pack();
        });
    }

    private JPanel createComponents() {
        JPanel top = new JPanel();
        top.setBackground(Color.WHITE);
        top.setLayout(new BorderLayout(0, 0));
        try {
            URL splashScreen = Mapacho.getSplashScreenURL();
            if (splashScreen != null) {
                try {
                    MapachoDownloadServiceListener.log("Splash screen url: " + splashScreen);
                    ImageIcon icon = new ImageIcon(splashScreen);
                    JLabel lbl = new JLabel(icon);
                    top.add((Component)lbl, "North");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                MapachoDownloadServiceListener.log("No splash Screen found, cannot display splash screen");
            }
        }
        catch (Exception e) {
            MapachoDownloadServiceListener.log("Could not load SplashScreen from malformed URL " + Mapacho.getSplashString());
        }
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Launching");
        return top;
    }

    public static void dispose() {
        MapachoDownloadServiceListener.log("disposing");
        if (instance != null) {
            instance.hide();
        }
    }

    public void updateMessage(String message) {
        SwingUtilities.invokeLater(() -> {
            MapachoDownloadServiceListener.log("Updating progress message to " + message);
            this.frame.setVisible(true);
            this.progressBar.setIndeterminate(true);
            this.progressBar.setString(message);
        });
    }

    private void hide() {
        SwingUtilities.invokeLater(() -> {
            if (this.frame != null) {
                MapachoDownloadServiceListener.log("hiding");
                this.frame.setVisible(false);
            } else {
                MapachoDownloadServiceListener.log("hiding as frame was null");
            }
        });
    }

    private void updateDownloadProgress(Integer overallPercent, String message, URL url, String version) {
        String file = url.getFile().substring(url.getFile().lastIndexOf("/") + 1);
        version = version != null ? " v" + version : "";
        String displayValue = message + " " + file + version;
        MapachoDownloadServiceListener.log("updateDownloadProgress(" + overallPercent + "," + displayValue + ")");
        SwingUtilities.invokeLater(() -> {
            if (overallPercent != null) {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(overallPercent);
            }
            this.progressBar.setString(displayValue);
        });
    }

    public void progress(URL url, String string, long l, long l1, int overallPercent) {
        this.updateDownloadProgress(overallPercent, "Downloading ", url, string);
    }

    public void validating(URL url, String string, long l, long l1, int overallPercent) {
        this.updateDownloadProgress(overallPercent, "Validating ", url, string);
    }

    public void upgradingArchive(URL url, String string, int i, int overallPercent) {
        this.updateDownloadProgress(overallPercent, "Upgrading ", url, string);
    }

    public void downloadFailed(URL url, String string) {
        this.updateDownloadProgress(0, "Download failed ", url, string);
    }

    private static void log(String message) {
        Mapacho.log("[MapachoDownloadServiceListener]" + message);
    }

    public static void main(String[] args) throws Exception {
        Thread.sleep(5000L);
    }

    public static MapachoDownloadServiceListener getInstance() {
        return instance;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    static {
        MapachoDownloadServiceListener.log("MapachoDownloadServiceListener class loaded. System splash screen: " + SplashScreen.getSplashScreen());
        Thread sdh = new Thread("Shutdown Hook"){

            @Override
            public void run() {
                Mapacho.log("MapachoDownloadServiceListener shutdownhook starts ");
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    Mapacho.log("MapachoDownloadServiceListener shutdownhook ex " + e);
                }
                Mapacho.log("MapachoDownloadServiceListener shutdownhook ends");
            }
        };
        Runtime.getRuntime().addShutdownHook(sdh);
    }
}

