/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client;

import java.awt.SplashScreen;
import java.io.File;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import uno.anahata.mapacho.client.LoadingStage;
import uno.anahata.mapacho.client.Mapacho;

public class MapachoPreloader
extends Preloader {
    private static MapachoPreloader instance;
    LoadingStage loadingStage;
    Image splashImage;

    public MapachoPreloader() {
        Mapacho.log("MapachoPreloader instantiated");
        instance = this;
    }

    public void init() throws Exception {
        Mapacho.log("MapachoPreloader init()");
        this.splashImage = new Image(new File(Mapacho.getSplashString()).toURI().toURL().toExternalForm(), true);
    }

    public void start(Stage stage) throws Exception {
        Mapacho.log("MapachoPreloader entry start()");
        this.loadingStage = new LoadingStage(stage, this.splashImage);
        stage.show();
        Mapacho.log("MapachoPreloader exit start()");
        Platform.runLater(() -> {
            if (SplashScreen.getSplashScreen() != null && SplashScreen.getSplashScreen().isVisible()) {
                Mapacho.log("Closing native splash screen");
                SplashScreen.getSplashScreen().close();
            }
        });
    }

    public boolean handleErrorNotification(Preloader.ErrorNotification info) {
        return this.loadingStage.handleErrorNotification(info);
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification info) {
        this.loadingStage.handleApplicationNotification(info);
    }

    public void handleStateChangeNotification(Preloader.StateChangeNotification info) {
        this.loadingStage.handleStateChangeNotification(info);
    }

    public void handleProgressNotification(Preloader.ProgressNotification info) {
        this.loadingStage.handleProgressNotification(info);
    }

    public static MapachoPreloader getInstance() {
        return instance;
    }

    static {
        Mapacho.log("MapachoPreloader static bloc. Splash = " + SplashScreen.getSplashScreen());
    }
}

