/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client;

import java.io.ObjectOutputStream;
import java.net.Socket;
import javafx.application.Preloader;
import javafx.stage.Stage;
import uno.anahata.mapacho.client.LoadingStage;
import uno.anahata.mapacho.client.Mapacho;

public class TcpSocketPreloaderProxy
extends Preloader {
    private Socket socket;
    private ObjectOutputStream oos;

    public void init() {
        try {
            this.socket = new Socket("localhost", (int)new Integer(Mapacho.getPreloaderPort()));
            this.oos = new ObjectOutputStream(this.socket.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public boolean handleErrorNotification(Preloader.ErrorNotification info) {
        return false;
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification info) {
        this.transmit(info);
        if (info == LoadingStage.StateNotification.DISPOSE) {
            this.close();
        }
    }

    public void handleStateChangeNotification(Preloader.StateChangeNotification info) {
    }

    public void handleProgressNotification(Preloader.ProgressNotification info) {
    }

    private void transmit(Preloader.PreloaderNotification info) {
        try {
            if (this.socket.isClosed()) {
                Mapacho.log("ERROR Socket is closed. Cannot transmit: " + info + " ");
            } else {
                Mapacho.log("Transmitting " + info);
                this.oos.writeObject(info);
                this.oos.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void close() {
        try {
            Mapacho.log("Closing Preloader socket");
            this.socket.close();
            Mapacho.log("Preloader socket closed");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void start(Stage primaryStage) throws Exception {
    }
}

