/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client.deploy;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.application.Preloader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import uno.anahata.mapacho.client.JavaFxDeployer;
import uno.anahata.mapacho.client.LoadingStage;
import uno.anahata.mapacho.client.Mapacho;
import uno.anahata.mapacho.client.deploy.Repo;
import uno.anahata.mapacho.client.exec.ExecUtils;
import uno.anahata.mapacho.client.io.AbstractDownloadTask;
import uno.anahata.mapacho.client.io.ArtifactDownloadTask;
import uno.anahata.mapacho.client.io.DescriptorDownloadTask;
import uno.anahata.mapacho.client.io.MapachoServletJreDownloadTask;
import uno.anahata.mapacho.client.io.SplashScreenDownloadTask;
import uno.anahata.mapacho.common.app.MapachoApplication;
import uno.anahata.mapacho.common.app.MapachoArtifact;
import uno.anahata.mapacho.common.runtime.JRE;

public class Deployer
extends Thread {
    private ExecutorService downloaderThreadPool = Executors.newFixedThreadPool(8);
    private MapachoApplication app;
    private ServerSocket preloaderSocket;
    private static final String PRELOADER_PORT_JVM_PROP_PREFFIX = "-Dmapacho.preloader.port=";

    public Deployer() {
        super("MapachoDeployer");
    }

    @Override
    public void run() {
        try {
            if (!this.reLaunch()) {
                this.deploy();
                this.launch();
            }
            Mapacho.log("************************** JVM launched ******************************");
            Mapacho.log("           `     `  `...`              `                               \n                      `   ```++/o+/:-`    `   ``      `            `            \n                    ``  `++`/s.oosso+o:`       `        `        `.             \n                     ` ``+s-/+-:/yo.-yds/`     `-++:.    ` `           `        \n                      ````-///++o+--sdmmhs:.   -sssoo:`    `  ``       ``       \n                  ` `` -/++os/syso/+soshmmhso/::ososhho:.   /so:.   `` `        \n            ``  ` ``  -o+-..-/s+:.:oy+oydddhddddhhdddddso+:/ysyo:`       `      \n                   `  .++/...-::+shdmmmmmNNmmmmmmNNNmmmmmdhhdhso-`   `  `. ` `` \n                      ``oydyyyhdmmmmmNNNNNNmmmmmmmNmNNNNNNNNmmhyss+:.`` `` ```  \n               .--.` `.-syddmmmmmmmmNNNmmddddmmdmmmmNNNNNNNNNNNNmmdys+-```````  \n              -+ooos++shhdmmmmmmmmmmddddmmddddmmmdddNNNNNNNNNNNNNNNmdhs+.`` ``` \n              `...-syshdmmmmmmmmmmmmdmmhhdmmmmdddmNmNNNNNNNNNNNNNNNNNmdss-`   ``\n               ` `:sydmmmmmmmmmmmmmmmdyddmdhddddyodNNNNNNNNNddddmmNNNNNmsy.`````\n           `.   -oyhmmmmmmmmmmmmmmmmm+yhmyyyymNmhdmNNNNNNNNNhNNmddhdNNNNmss`````\n         `-+/-`/yhdmmmmmmmmmmmmmmmmmdosddhyyhmddNNNNNNNNNNNNyyyhdddyydNNNmh`````\n         `/o++shhmmmmmmmmmmmmmmmmddmmmmmdddddmmmNNNNNNNNNNNNhyhmhhmNmshNNNh.````\n          `.-yshmmmmmmmmmmmmmmmmhdmmmmmmmmmmmdddddhhNNNNNNNNmmdhyyshNmyhNNy.````\n           `:syddmmmmmmmmmmmmmmhmmmmmmmmmmNmhmhhhdmdNmhddNNNmydmshdhhNhhmdo`````\n          -/shddmmmmmmmmmmmmmmhdmmmmmmmmmmmmdddddddddyyddmmmNmsddydmdhhdmy-`````\n          ooyddmmmmmmmmmmmmmmdhmmmmmmmmmmmmmmdddddmmNmhohdddhmmymyddyomhh/````.`\n        `.+sdddmmmmmmmmmmmmmmhmmmmmmmmmmmdyydhdosyssyyyyhhdmNddddmNNNhsy.````.``\n      ` .+oddmmmmmmmmmmmmmmmmhmmmmmmmmmhddhhmddhhhsmdymmydsssmhmNNNNNNy:````````\n     ` `:odddddmmmmmmmmmmmmmmhmmmmmmdhhddmmmmNNNNNddyhhhyhyyyymhmNNNNNh:````````\n  `  ``/+sddddmmmmmmmmmmmmmmhmmmmdhhddmmmmmmmNNNNNNNNmmmNNNNmdhmyNNNNNho``````.`\n     ``+oddmmmmmmmmmmmmmmmmmymmhyshmmmmmmmNmmNNNNNNNNNNNNNNNNNmyyhNNNNys``.`````\n      :ooddddmmmmmmmmmmmmmmdhhyyhmmmmmmmmmmNNNNNNNNNmNNNNNNNNNNydhNNNNhy````````\n     `:+syddmmmmmmmmmmmmmmmhdddhhmmmmmmmmNNNNmNmNmNNNNNNNNNNNNNmhmhNNNyy``.`````\n     .//yhyhdmmmmmmmmmmmmmmmddmyhhdmmmmmmmNNNNmmmNNNNNNNNNNNNNNNmysdNNys````````\n    ./sshyddhhhdddmmmmhhhhydmmhdhhhhdmmdmmmmmNNNmNNNNNNNNNNNNNNNNmhhmNyo..``` ``\n     -s/ydhhhdddhyyddydmmmmoyhmhmhdmdh/osyoshyhhhhhmmdmNNNNNNNNNNmhhydy-```` ```\n      ++::shddhhyhmmydmmmms:`+yhhmmhdmmsoyyohssh+mm+om+syyhosyyhyodNdsh````   ``\n      :odho/:/+sy+omymmmmds-  .oysmmdhmmmhhhhhhhoyhssyshsys+oodyhdhy+:``````  ``\n      /+dddddhyo+/smymmmmyhs`  `:symmmhdmmmmmmmmdhyhdddhhhdNNdymd+-``````````  `\n      oshdddddmmdyymymmmmsyyy+:---:sdmmmhddmmmmmmmmymmmmNNNdhmdo-.````````````  \n     `+ysdddddmddsydshmmhoyyddssyy/-:sdmmmmddddmmmmhmmmmmddmds-``````````.````  \n      .oosdddddddoshhsdmy+`yyyyyso/:``:sdmmmmmmdddydddddmmho-`````.`````````` ``\n       `oyydddddyy+yoyhyoo -oyyshs-   ``:ohdmmmmmmmmmmdds/.```````````````` `` `\n        :hshdddydsoyysysys  `+o-.-.  `````./ooshdhyyso/-.```````    ``` `  `  ``\n        `/ysdddyyhdoydmdds   :yss+:-```````````-/:/osssoo````   ````````````````\n         `+yydddmmmhhmmmmo`  ohysysh/````````.:+yhyysooyy-`    `````````````````\n`         `/yymmmmmmhhmmmh- `odsshyyo: `.:+syysddhhyyssyss.   ``````````````````\n`   `      `ohhdmmmmmsdmmms-/ommhsyy-./yhddhhymdsyhddmydyys/.```..`````````````.\n    -`     `/yyhmdmmh-/dmmdyysdh+-.:/shhhddmmmmmmmmddhdmmmmmy+:....`````````````\n`   ++`  ` ``/sysys+..symmmdsdy:`.+ddshyyhmhsddddmmmmmdhmmddmdy+-::-````````````\n    os/   `` `.//-:/ohmdymmmddo.:ymdhsyyhsyyydddhyhddmmdhdhhhhdyysyys:``````````\n    oso  ``    `+yydddhyyymmmmhssddymmhyyhdshhysohydsmmmmsmmdhddhsysdo.`````` ``\n`   .sy` ``   ` `/yhsyyyhdhdddhhhhdyhdmmmyhyhsssshymhmmNNsmNNhyhhydso.``````````\n```  .++-`   `` `-+yyydmmmmddddhddyhdyshhhhsodhhhyhhhmNNNdhmmyhdNhys.....`.`` ``\n  `   `+o+.`  `    -ohydmmmmmmsdmmdyy++oshmmdhdhhhyymmNNmm:/:-:ohss//``.``.   ``\n       `/yo.        `oyhhdmmmmmhydyhohsyyhmdsyhssoysmmNNNhshhy/.-s:.-`````   ``.\n         :so.       .-:+sshdmmmmmhsoyhsmmmmdhddsoshshmmNdsmNNNmo/y`-.`..-`  ````\n          os/           `-oyhdmmmmmdhhyhddhhhdhydsyddmmy:hmmmmd++:`.``.-.. ```.`\n          :yy.             -hshdmmmmmmmdhhddyhddhhhdhhd+`-mmmys/-`-`:.:..`  ````\n     `    -yh:              oymdshdmmmmmmmmmmdhhddhdmmmo`.dsoo-`````.:````` ````\n    `.    `oho             `shmmsmdhhhdddmmmmmmmmmmmmmd:.:/:.``````````.-```````\n          `.sy-     ` `    `odmmsmmmmmdo+sosoosyyyhyoo+-`````````````````````` `\n          ``:ss       `     ohmmomddddmys:-----:/:--.```````````````````````````\n          -`.ss           ``+smmodmddmdyy:  ``.-:////```````````````````````````\n            `ys  ` `.`   -ssyodmshddddmhy+.:+sssssys/` `````````````````````````\n     ``    .`hy` `.`-`.:/syhyyyhyydddddmysydymmdhsy+-` `` ``````````````````````\n    `       /ss ..:.:o+/hhyshyshhdmmddmmhhds+ossysyo+- `````````````````````````\n   .:      .ho:.  -/+yosoyyo:-sddsmmmmmmmho-  -sho/``` `````````````````````````\n  `   .` `:ss.`--`` -sds/sdy/ :yssommmmmmdo+` `````    `````````````````````````\n      ` `-so`  `.`  `:s+.-o+```+:.-sdmmmmdy/+:` +.:/`  `````````` ``````````````\n        /yo`.  ` ```  .`  `     /ymdhhmdmmmh-o-`ooys`  ``````````` `````````````\n      `+os` `                   `+hmmdhdmmmmyss+ymdho:- `   ``  ``  ````````````\n     -ooy.                     `./sshhhsmmmmmhshmhshydo-`          `` ``````````\n    -s:h+                 ```./o+shhmsyyhmmmmmdmm+hhoysy+`         `  `  ```````\n   `oo+d.                 `:oyoyossyssyhsymmmmmdmyosossy+`     `      ``` ``````\n   /oooy                  -//o+ydsydh+ssysymmmddmmys-`.-`      ````   `      ```\n  `oysss     ``            `..+os/oo+`:o/+/dmmdddmmyo.          ``    ``     ```\n  /oysso     `                .-. ```  /...ommdddmmdyo-       `                `\n  +hysoo           `     `          `.-+ohhyhmmmmmmmdyo-                `   `` `\n `ohysos           ``` `````    ..:+oohdhhhdsdmdmmmmmhy+..-:`              ` `` \n .ohhsss           `````````` :+shyssshdmmyssyddddmmmmyhoodo:                .` \n `ohhshs.              `````` `-sy+ysysohy+ysdddddddddyshmmho`                  \n  +hhoho:               ````    osyhyyyy+/sdsdddddddmhhdysdmyo.               ` \n  /yhsys/                ` `    //+oshhs.:syyddmddddmdyososhyh+                 \n  .ohhsh+`                ` `   `` `:+o/`oysddddddddddoooyhssh+                 \n   +shsys/                           `..+shsmddddddddyyoyssoss:                 \n   .ohhoho:                        ``./+ohsdmdddddddhsy+-..`.:`   `` `        ``\n    -ohhsyo:`                    `-o+ossyshmmdddmmmdyy/`          ``  -`        \n     :shhsso//:.`            `.-/+osyddyydmmmmmmmmhyh+.             `           \n      /yhhysoooo//-.``   ``-:///shdddyydddmmmmmmdyys:.              `           \n      `/yhhhyssoo+o+++-:/:/+// `yhyyhddddddddddhyyo.                          ` \n       `/yhhhhhhyssoo++oyhyo++:+yhddddddddddhs+os/`                           ` \n        `/yhhhhhhhhhhyyyyyhhhdddddddddhdhhy/`-+/.                          ` `  \n          :yhhhhhhhhddddddhhdddddddddhyssooo--`                                `\n           -oyhhhhhhhhhhdhhhdddhhyso++ooo/.          `         `          ``  ``\n            `:+oossyyyyyyssso++++o+//:-`                                  ``  ``\n               `.-:/++++/+////:-.`                                     .    ` ``\n                   `   `                                    .    `            ` ");
            Mapacho.log("************************** JVM launched ******************************");
            JavaFxDeployer.runAsap(() -> LoadingStage.getInstance().updateMessage("Awaiting Remote Preloader Connection"));
            Mapacho.log("Preparing to accept on preloader socket");
            try (Socket s = this.preloaderSocket.accept();){
                JavaFxDeployer.runAsap(() -> LoadingStage.getInstance().updateMessage("Remote Preloader connected"));
                Mapacho.log("Got socket");
                try (ObjectInputStream ois = new ObjectInputStream(s.getInputStream());){
                    Object obj;
                    while ((obj = ois.readObject()) != null) {
                        Preloader.PreloaderNotification pn = (Preloader.PreloaderNotification)obj;
                        Mapacho.log("[TCP] Got remote preloader notification: " + pn);
                        JavaFxDeployer.runAsap(() -> LoadingStage.getInstance().handleApplicationNotification(pn));
                        if (obj != LoadingStage.StateNotification.DISPOSE) continue;
                        Mapacho.log("[TCP] remote preloader notification was DISPOSE, closing Socket");
                        break;
                    }
                }
            }
            this.preloaderSocket.close();
            Mapacho.log("Deployer.run() closing ServerSocket");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Mapacho.log(e.toString());
        }
        Platform.exit();
    }

    public void deploy() throws Exception {
        JavaFxDeployer.runAsap(() -> LoadingStage.getInstance().updateMessage("Deploying"));
        long ts = System.currentTimeMillis();
        this.app = this.getDescriptor();
        this.app.setCodeBase(Mapacho.getCodeBase());
        JRE jre = this.app.getJre();
        if (!jre.matches()) {
            Mapacho.log("JRE specified in descriptor " + jre + " does not match operating system name " + System.getProperty("os.name"));
            throw new RuntimeException("JRE specified in descriptor " + jre + " does not match operating system name " + System.getProperty("os.name"));
        }
        jre.setOs(System.getProperty("os.name"));
        if (StringUtils.isBlank((CharSequence)jre.getArch())) {
            jre.setArch(System.getProperty("os.arch"));
        }
        File jreLocation = jre.getLocation(Repo.JRE_DIR);
        File splash = this.getSplashFile();
        ArrayList<AbstractDownloadTask> tasks = new ArrayList<AbstractDownloadTask>();
        if (splash != null && !splash.exists()) {
            tasks.add(new SplashScreenDownloadTask(splash));
        }
        Mapacho.log("JRE location: " + jreLocation);
        if (!jreLocation.exists()) {
            tasks.add(new MapachoServletJreDownloadTask(jre));
        }
        File jarRepo = Deployer.getJarRepo();
        Mapacho.log("Jar Repo: " + jarRepo);
        for (MapachoArtifact arti : this.app.getMatchingClassPath()) {
            if (arti.getFile(jarRepo).exists()) continue;
            tasks.add(new ArtifactDownloadTask(arti, jarRepo));
        }
        for (MapachoArtifact arti : this.app.getMatchingLibPath()) {
            if (arti.getLibDir(jarRepo).exists()) continue;
            tasks.add(new ArtifactDownloadTask(arti, jarRepo));
        }
        for (AbstractDownloadTask task : tasks) {
            this.downloaderThreadPool.submit((Runnable)((Object)task));
        }
        this.downloaderThreadPool.shutdown();
        this.downloaderThreadPool.awaitTermination(60L, TimeUnit.MINUTES);
        Mapacho.log("All Deployment tasks finished. Commit Log:");
        for (AbstractDownloadTask adt : tasks) {
            Mapacho.log("[Commited]" + adt.getComitted());
            if (adt.getComitted() != null) continue;
            throw new RuntimeException("At least one download Tasks did not succeed. Aborting", adt.getDownloadException());
        }
        Mapacho.log("All Deployment tasks finished");
    }

    private String getLibPath() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (MapachoArtifact ma : this.app.getMatchingLibPath()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(ma.getLibDir(Deployer.getJarRepo()));
        }
        return sb.toString();
    }

    private String getClassPath() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (MapachoArtifact ma : this.app.getMatchingClassPath()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(ma.getFile(Deployer.getJarRepo()));
        }
        return sb.toString();
    }

    public void launch() throws Exception {
        JavaFxDeployer.runAsap(() -> LoadingStage.getInstance().updateMessage("Launching"));
        File splash = this.getSplashFile();
        long ts = System.currentTimeMillis();
        File java = this.app.getJre().getExecutable(Repo.JRE_DIR);
        ArrayList<String> cmdArray = new ArrayList<String>();
        cmdArray.add(java.getAbsolutePath());
        cmdArray.add("-client");
        if (splash != null) {
            // empty if block
        }
        for (String s : this.app.getJvmArgs().split(" ")) {
            cmdArray.add(s);
        }
        for (String s : System.getProperties().stringPropertyNames()) {
            if (!s.startsWith("jnlp.")) continue;
            String stripped = s.substring("jnlp.".length());
            cmdArray.add("-D" + stripped + "=" + System.getProperty(s));
        }
        cmdArray.add("-Dmapacho.java.home=" + System.getProperty("java.home"));
        cmdArray.add("-Danahatautil.nonjws.application.url=" + Mapacho.getCodeBase() + "../");
        if (!StringUtils.isBlank((CharSequence)this.app.getPreloaderClass())) {
            cmdArray.add("-Djavafx.preloader=" + this.app.getPreloaderClass());
        }
        if (this.getLibPath().length() > 0) {
            cmdArray.add("-Djava.library.path=" + this.getLibPath());
        }
        cmdArray.add("-cp");
        cmdArray.add(this.getClassPath());
        cmdArray.add(this.app.getMainClass());
        cmdArray.addAll(JavaFxDeployer.getStartupArguments());
        cmdArray.addAll(this.app.getArguments());
        Mapacho.log("Hiding main stage");
        ts = System.currentTimeMillis() - ts;
        Mapacho.log("Launching method took " + ts + " until java process launching");
        File launcher = Deployer.getCachedLauncherFile();
        if (!launcher.exists()) {
            File temp = new File(launcher.getParent(), launcher.getName() + ".tmp");
            FileUtils.writeLines((File)temp, cmdArray);
            boolean success = temp.renameTo(launcher);
            if (success) {
                Mapacho.log("Stored cached launcher at: " + launcher);
            } else {
                Mapacho.log("Could not store cached launcher at: " + launcher);
            }
        }
        this.initPreloaderSocket(cmdArray);
        Process p = ExecUtils.run(cmdArray.toArray(new String[0]));
        Mapacho.log("Process launched. Calling Platform.exit");
    }

    public MapachoApplication getDescriptor() throws Exception {
        DescriptorDownloadTask ddt = new DescriptorDownloadTask(Mapacho.getDescriptorId());
        Future<?> result = this.downloaderThreadPool.submit((Runnable)((Object)ddt));
        result.get();
        MapachoApplication descriptor = ddt.getDescriptor();
        if (descriptor == null) {
            throw new IllegalStateException("Descriptor " + Mapacho.getDescriptorId() + " did not download correctly");
        }
        Mapacho.log("got descriptor " + descriptor);
        return descriptor;
    }

    public static File getDevAppSer() throws Exception {
        return new File(System.getProperty("user.home") + File.separator + ".anahata", "dev-app.ser");
    }

    private boolean reLaunch() throws Exception {
        File launcher = Deployer.getCachedLauncherFile();
        if (launcher.exists()) {
            JavaFxDeployer.runAsap(() -> LoadingStage.getInstance().updateMessage("Launching"));
            List cmdArray = FileUtils.readLines((File)launcher, (String)"UTF-8");
            this.initPreloaderSocket(cmdArray);
            ExecUtils.run(cmdArray.toArray(new String[0]));
            return true;
        }
        return false;
    }

    public static File getCachedLauncherFile() {
        String launcherName = Mapacho.getDescriptorId() + "__V" + Mapacho.getDescriptorTimestamp() + ".txt";
        File cachedLauncher = new File(Deployer.getJarRepo(), launcherName);
        return cachedLauncher;
    }

    public File getSplashFile() {
        if (this.app.getSplash() != null) {
            String splashFileName = Mapacho.getDescriptorId() + "__V" + Mapacho.getDescriptorTimestamp() + this.app.getSplash().replace("/", "_");
            File cachedLauncher = new File(Deployer.getJarRepo(), splashFileName);
            return cachedLauncher;
        }
        return null;
    }

    public static File getJarRepo() {
        URL codeBase = Mapacho.getCodeBase();
        String prot = codeBase.getProtocol();
        String host = codeBase.getHost();
        int port = codeBase.getPort();
        String path = codeBase.getPath().replace("/", "_");
        String s1 = prot + "_" + host + "_" + port + "_" + path;
        File ret = new File(Repo.MAPACHO_DIR, s1);
        ret.mkdirs();
        return ret;
    }

    private void initPreloaderSocket(List<String> cmds) throws IOException {
        this.preloaderSocket = new ServerSocket(0);
        String prop = PRELOADER_PORT_JVM_PROP_PREFFIX + this.preloaderSocket.getLocalPort();
        cmds.add(2, prop);
    }
}

