/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client.exec;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import uno.anahata.mapacho.client.Mapacho;
import uno.anahata.mapacho.client.exec.ProcessStreamHandler;

public class ExecUtils {
    private static void debug(String[] cmds) {
        StringBuilder out = new StringBuilder();
        for (String cmd : cmds) {
            out.append(cmd);
            out.append(" ");
        }
        Mapacho.log("Executing " + out);
    }

    public static final Process runOrfail(String[] cmds, int timeoutSecs) throws Exception {
        Process p = ExecUtils.run(cmds);
        p.waitFor(timeoutSecs, TimeUnit.SECONDS);
        if (p.exitValue() != 0) {
            throw new IllegalStateException("Executing " + Arrays.toString(cmds) + " did not exit in " + timeoutSecs + " seconds");
        }
        return p;
    }

    public static final Process run(String[] cmds) throws Exception {
        ExecUtils.debug(cmds);
        Process p = Runtime.getRuntime().exec(cmds);
        new ProcessStreamHandler(p, true).start();
        new ProcessStreamHandler(p, false).start();
        return p;
    }
}

