/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client.io;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import uno.anahata.mapacho.client.JavaFxDeployer;
import uno.anahata.mapacho.client.LoadingStage;
import uno.anahata.mapacho.client.Mapacho;
import uno.anahata.mapacho.client.ProgressBarWithLabel;
import uno.anahata.mapacho.client.deploy.Repo;
import uno.anahata.mapacho.client.io.ProgressInputStream;
import uno.anahata.mapacho.client.io.ProgressMonitor;
import uno.anahata.mapacho.common.http.HttpConnectionUtils;

public abstract class AbstractDownloadTask
extends Task<File>
implements ProgressMonitor {
    protected URL url;
    protected File download;
    protected Exception downloadException;
    protected File comitted;
    protected HttpURLConnection conn;
    protected ProgressBarWithLabel progressBar;

    protected abstract void process(InputStream var1, long var2) throws Exception;

    protected abstract File commit() throws Exception;

    protected void init(HttpURLConnection conn) throws Exception {
    }

    protected void scheduled() {
        JavaFxDeployer.runAsap(() -> {
            this.progressBar = LoadingStage.getInstance().createProgressBar();
            this.progressBar.visibleProperty().bind((ObservableValue)this.runningProperty());
            this.progressBar.getLabel().textProperty().bind((ObservableValue)this.titleProperty());
            this.progressBar.getProgressBar().progressProperty().bind((ObservableValue)this.progressProperty());
            Mapacho.log("Progress bar added for " + this.url);
        });
    }

    protected File call() throws Exception {
        for (int i = 0; i < 3; ++i) {
            try {
                return this.doCall();
            }
            catch (Exception ex) {
                this.downloadException = this.downloadException == null ? ex : new Exception("Download failed on attempt 1", ex);
                ex.printStackTrace(System.out);
                this.updateTitle("Retrying");
                continue;
            }
        }
        throw this.downloadException;
    }

    protected File doCall() throws Exception {
        block26: {
            this.updateProgress(-1L, 1L);
            this.conn = this.connect(this.url);
            this.updateTitle("Connected: " + this.getDisplayResourceName());
            String contentType = this.conn.getContentType();
            long contentLength = this.conn.getContentLengthLong();
            long realLength = this.conn.getHeaderFieldLong("Real-Content-Length", -1L);
            if (realLength == -1L && contentLength == -1L) {
                this.updateProgress(-1L, 1L);
            }
            this.updateTitle("Downloading: " + this.getDisplayResourceName());
            Object ret = null;
            try (InputStream is = this.conn.getInputStream();){
                Mapacho.log("Input stream is: " + is);
                if (contentLength != -1L) {
                    Mapacho.log("Wrapping in ProgressInputStream");
                    try (ProgressInputStream fis = new ProgressInputStream(is, contentLength, this);){
                        Mapacho.log("Processing ProgressInputStream");
                        this.process(fis, -1L);
                        break block26;
                    }
                }
                this.process(is, realLength);
            }
        }
        this.updateTitle("Comitting : " + this.conn.getURL().getFile());
        this.comitted = this.commit();
        this.updateTitle("Completed: " + this.conn.getURL().getFile());
        Mapacho.log(this + " commited " + this.comitted);
        return this.comitted;
    }

    protected String getDisplayResourceName() {
        if (this.conn != null) {
            return this.conn.getURL().getFile();
        }
        if (this.url != null) {
            return this.url.getFile();
        }
        return "";
    }

    @Override
    public void progress(long cur, long total) {
        this.updateProgress(cur, total);
    }

    protected void done() {
        if (this.progressBar != null) {
            JavaFxDeployer.runAsap(() -> this.progressBar.dispose());
            Mapacho.log("Progress bar removed for " + this.url);
        }
    }

    protected File makeTempDownloadTarget(boolean dir) throws IOException {
        String fileName = this.url.getFile();
        String preffix = "download";
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        if (fileName.contains("?")) {
            fileName = fileName.substring(0, fileName.indexOf("?"));
        }
        if (this.url.getQuery() != null) {
            preffix = preffix + "_" + this.url.getQuery().replace("&", "_").replace("=", "_");
        }
        File parent = Repo.TEMP_DIR;
        Mapacho.log("Preffix=" + preffix + " suffix=" + fileName + " parent=" + parent);
        File ret = File.createTempFile(preffix, fileName, parent);
        if (dir) {
            ret.delete();
            ret.mkdirs();
        }
        ret.deleteOnExit();
        Mapacho.log("Download target :" + ret);
        return ret;
    }

    private HttpURLConnection connect(URL url) throws Exception {
        this.updateTitle("Connecting to " + url);
        HttpURLConnection localConn = (HttpURLConnection)url.openConnection();
        localConn.setInstanceFollowRedirects(true);
        localConn.setAllowUserInteraction(false);
        localConn.setUseCaches(false);
        this.init(localConn);
        Mapacho.log("Content-type:" + localConn.getContentType());
        Mapacho.log("Content-encoding:" + localConn.getContentEncoding());
        Mapacho.log("Content-Length:" + localConn.getContentLengthLong());
        Mapacho.log("Real-Content-Length:" + localConn.getHeaderField("Real-Content-Length"));
        Mapacho.log("Response-code:" + localConn.getResponseCode());
        Mapacho.log("Headers:" + localConn.getHeaderFields());
        String movedTo = HttpConnectionUtils.getMovedToLocation((HttpURLConnection)localConn);
        if (movedTo != null) {
            localConn.disconnect();
            return this.connect(new URL(movedTo));
        }
        this.url = url;
        return localConn;
    }

    protected static final String encode(String arg) throws UnsupportedEncodingException {
        if (arg == null) {
            arg = "";
        }
        return URLEncoder.encode(arg, "UTF-8");
    }

    @ConstructorProperties(value={"url", "download", "downloadException", "comitted", "conn", "progressBar"})
    public AbstractDownloadTask(URL url, File download, Exception downloadException, File comitted, HttpURLConnection conn, ProgressBarWithLabel progressBar) {
        this.url = url;
        this.download = download;
        this.downloadException = downloadException;
        this.comitted = comitted;
        this.conn = conn;
        this.progressBar = progressBar;
    }

    public AbstractDownloadTask() {
    }

    public URL getUrl() {
        return this.url;
    }

    public File getDownload() {
        return this.download;
    }

    public Exception getDownloadException() {
        return this.downloadException;
    }

    public File getComitted() {
        return this.comitted;
    }
}

