/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.io.IOUtils;
import uno.anahata.mapacho.client.Mapacho;
import uno.anahata.mapacho.client.deploy.Repo;
import uno.anahata.mapacho.client.io.AbstractDownloadTask;
import uno.anahata.mapacho.client.io.ProgressInputStream;
import uno.anahata.mapacho.common.app.MapachoArtifact;
import uno.anahata.mapacho.common.io.MapachoIOUtils;
import uno.anahata.mapacho.common.jardiff.JarDiffPatcher;

public class ArtifactDownloadTask
extends AbstractDownloadTask {
    public static final String PACK200_GZIP_ENCODING = "pack200-gzip";
    public static final String JAR_MIMETYPE = "application/x-java-archive";
    public static final String JARDIFF_MIMETYPE = "application/x-java-archive-diff";
    private MapachoArtifact requestedVersion;
    private MapachoArtifact currentVersion;
    private File jarRepo;

    public ArtifactDownloadTask(MapachoArtifact ma, File jarRepo) throws Exception {
        this.requestedVersion = ma;
        this.jarRepo = jarRepo;
        StringBuilder sb = new StringBuilder(ma.getApplication().getCodeBase().toString());
        sb.append("lib2/").append(ma.getName()).append(".jar?");
        sb.append("version-id");
        sb.append("=");
        sb.append(ArtifactDownloadTask.encode(ma.getVersion()));
        sb.append("&");
        sb.append("locale");
        sb.append("=");
        sb.append(ArtifactDownloadTask.encode(ma.getLocale()));
        sb.append("&");
        sb.append("os");
        sb.append("=");
        sb.append(ArtifactDownloadTask.encode(ma.getOs()));
        sb.append("&");
        sb.append("arch");
        sb.append("=");
        sb.append(ArtifactDownloadTask.encode(ma.getArch()));
        this.currentVersion = ma.getBestCurrentVersionMatch(jarRepo);
        if (this.currentVersion != null) {
            sb.append("&");
            sb.append("current-version-id");
            sb.append("=");
            sb.append(ArtifactDownloadTask.encode(this.currentVersion.getVersion()));
        }
        this.url = new URL(sb.toString());
    }

    @Override
    protected String getDisplayResourceName() {
        return this.requestedVersion.getJarPackGzFileName();
    }

    @Override
    protected void init(HttpURLConnection conn) throws Exception {
        conn.addRequestProperty("encoding", PACK200_GZIP_ENCODING);
        conn.addRequestProperty("accept-encoding", PACK200_GZIP_ENCODING);
    }

    @Override
    protected void process(InputStream is, long realLength) throws Exception {
        if (PACK200_GZIP_ENCODING.equals(this.conn.getContentEncoding())) {
            try (GZIPInputStream gzipIs = new GZIPInputStream(is);
                 Pack200CompressorInputStream tais = new Pack200CompressorInputStream((InputStream)gzipIs);){
                if (realLength != -1L) {
                    try (ProgressInputStream pis = new ProgressInputStream((InputStream)tais, realLength, this);){
                        this.doProcess(pis);
                    }
                }
                this.doProcess((InputStream)tais);
            }
        } else {
            this.doProcess(is);
        }
    }

    private void doProcess(InputStream is) throws Exception {
        this.download = this.makeTempDownloadTarget(false);
        try (FileOutputStream fos = new FileOutputStream(this.download);){
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
    }

    @Override
    protected File commit() throws Exception {
        File requestedVersionUncomitted;
        File requestedVersionUncomittedLibDir = null;
        File requestedVersionInRepo = this.requestedVersion.getFile(this.jarRepo);
        File requestedVersionInRepoLibDir = this.requestedVersion.getLibDir(this.jarRepo);
        if (this.conn.getContentType().equals(JARDIFF_MIMETYPE)) {
            Mapacho.log("Appying JarDiff " + this.download + " to upgrade from " + this.currentVersion.getVersion() + " to " + this.requestedVersion.getVersion());
            requestedVersionUncomitted = File.createTempFile(this.requestedVersion.getJarFileName(), this.currentVersion.getJarFileName(), Repo.TEMP_DIR);
            this.updateTitle("Patching " + this.currentVersion.getName() + " to " + this.requestedVersion.getVersion());
            try (FileOutputStream fos = new FileOutputStream(requestedVersionUncomitted);){
                new JarDiffPatcher().applyPatch(a -> this.updateProgress(a, 100L), this.currentVersion.getFile(this.jarRepo).getPath(), this.download.getPath(), (OutputStream)fos);
            }
            Mapacho.log("JarDiff applied. Will commit: " + requestedVersionUncomitted + " exits=" + requestedVersionUncomitted.exists() + " length=" + requestedVersionUncomitted.length());
        } else {
            requestedVersionUncomitted = this.download;
        }
        if (this.requestedVersion.isNativeLib()) {
            requestedVersionUncomittedLibDir = this.makeTempDownloadTarget(true);
            MapachoIOUtils.extractJarFile((File)requestedVersionUncomitted, (File)requestedVersionUncomittedLibDir);
        }
        if (!requestedVersionInRepo.exists()) {
            boolean success = requestedVersionUncomitted.renameTo(requestedVersionInRepo);
            if (!success) {
                throw new IllegalStateException("Could not commit downloaded artifact from " + requestedVersionUncomitted + " to " + requestedVersionInRepo);
            }
            if (this.requestedVersion.isNativeLib() && !requestedVersionInRepoLibDir.exists() && !(success = requestedVersionUncomittedLibDir.renameTo(requestedVersionInRepoLibDir))) {
                throw new IllegalStateException("Could not commit extracted lib dir from " + requestedVersionUncomittedLibDir + " to " + requestedVersionInRepoLibDir);
            }
        }
        return requestedVersionInRepo;
    }
}

