/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client.io;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import uno.anahata.mapacho.client.Mapacho;
import uno.anahata.mapacho.client.deploy.Repo;
import uno.anahata.mapacho.client.exec.ExecUtils;
import uno.anahata.mapacho.client.io.TarGzDownloadTask;
import uno.anahata.mapacho.common.os.OSUtils;
import uno.anahata.mapacho.common.runtime.JRE;

public abstract class JreDownloadTask
extends TarGzDownloadTask {
    protected JRE jre;

    public JreDownloadTask(JRE jre) throws Exception {
        this.jre = jre;
        this.url = new URL(this.makeURL());
        Mapacho.log("JRE download URL = " + this.url);
    }

    protected abstract String makeURL() throws Exception;

    @Override
    protected File commit() throws Exception {
        File download = super.getDownload();
        File target = this.jre.getLocation(Repo.JRE_DIR);
        Mapacho.log("Comitting JRE from " + download + " to " + target);
        Validate.isTrue((download.listFiles().length == 1 ? 1 : 0) != 0, (String)"Download contains more than one entry", (Object[])new Object[0]);
        File source = download.listFiles()[0];
        Validate.isTrue((boolean)source.isDirectory(), (String)"Download contains one entry that is not a directory", (Object[])new Object[0]);
        Mapacho.log("Moving " + source + " to " + target);
        boolean success = source.renameTo(target);
        if (!success) {
            throw new IllegalStateException("Could not move downloaded JRE from " + source + " to " + target);
        }
        if (OSUtils.isLinux() || OSUtils.isMac()) {
            File java = this.jre.getExecutable(Repo.JRE_DIR);
            String[] cmd = new String[]{"chmod", "+x", java.getAbsolutePath()};
            Mapacho.log("Making java executable with " + Arrays.asList(cmd));
            ExecUtils.runOrfail(cmd, 5);
        } else {
            Mapacho.log("Not making java executable as os is neither linux or Mac. System.getProperty(\"os.name\") = " + System.getProperty("os.name"));
        }
        return target;
    }
}

