/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import uno.anahata.mapacho.client.io.ProgressMonitor;

public class ProgressInputStream
extends FilterInputStream {
    private long readCount;
    private long total;
    private ProgressMonitor progressMonitor;

    public ProgressInputStream(InputStream in, long total, ProgressMonitor pm) {
        super(in);
        this.total = total;
        this.progressMonitor = pm;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.progress(super.read(b, off, len));
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.progress(super.read(b));
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        this.progress(1);
        return ret;
    }

    private int progress(int count) {
        this.readCount += (long)count;
        this.progressMonitor.progress(this.readCount, this.total);
        return count;
    }
}

