/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.client.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import uno.anahata.mapacho.client.Mapacho;
import uno.anahata.mapacho.client.io.AbstractDownloadTask;

public abstract class TarGzDownloadTask
extends AbstractDownloadTask {
    @Override
    protected void process(InputStream is, long realLength) throws Exception {
        Mapacho.log("process() starts");
        this.updateTitle("Downloading");
        Mapacho.log("fetching download target");
        this.download = this.makeTempDownloadTarget(true);
        Mapacho.log("download target " + this.download);
        this.download.mkdirs();
        Mapacho.log("download dir created : " + this.download);
        long realReadCount = 0L;
        try (GzipCompressorInputStream gzipIs = new GzipCompressorInputStream(is);
             TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)gzipIs);){
            TarArchiveEntry entry = tais.getNextTarEntry();
            Mapacho.log(entry.getName());
            while (entry != null) {
                File target = new File(this.download, entry.getName());
                if (entry.isDirectory()) {
                    Mapacho.log("creating directory: " + target);
                    target.mkdirs();
                    Mapacho.log("directory: " + target + " created");
                } else {
                    byte[] content = new byte[(int)entry.getSize()];
                    tais.read(content);
                    try (FileOutputStream fos = new FileOutputStream(target);){
                        IOUtils.write((byte[])content, (OutputStream)fos);
                        Mapacho.log("Written: " + target + " size=" + target.length());
                    }
                    this.updateTitle("Downloading :" + entry.getName());
                    if (realLength != -1L) {
                        this.updateProgress(realReadCount += (long)content.length, realLength);
                    }
                }
                entry = tais.getNextTarEntry();
            }
        }
    }
}

