/*
 * Copyright 2016 Anahata Technologies Pty Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package uno.anahata.mapacho.common.io;

import java.io.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FilenameUtils;
/**
 *
 * @author pablo
 */
public class CachingOutputStream extends FilterOutputStream {
    
    private final StreamCache cache;
    
    public CachingOutputStream(OutputStream out, File target) throws IOException {
        super(out);
        cache = new StreamCache(target);
    }

    @Override
    public void close() throws IOException {
        super.close(); 
        cache.close();
    }

    @Override
    public void flush() throws IOException {
        super.flush(); 
        cache.getStream().flush();
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b); //To change body of generated methods, choose Tools | Templates.
        cache.getStream().write(b);
    }
    
}
