/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.plugin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import uno.anahata.mapacho.plugin.MapachoMojo;

public class AbstractResource {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type;
    private Artifact artifact;
    private List<Artifact> dependencies = new ArrayList<Artifact>();
    public static final String LMR_SNAPSHOT_DATEFORMAT = "yyyyMMdd.HHmmss";

    public synchronized void resolve(MapachoMojo resources) throws Exception {
        if (this.artifact != null) {
            System.out.println("Already resolved");
            return;
        }
        ArtifactRequest request = new ArtifactRequest();
        if (this.type == null) {
            this.type = "jar";
        }
        request.setArtifact((Artifact)new DefaultArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getType(), this.getVersion()));
        request.setRepositories(resources.getRemoteRepos());
        ArtifactResult result = resources.getRepoSystem().resolveArtifact(resources.getRepoSession(), request);
        this.artifact = result.getArtifact();
        System.out.println("Resolved artifact " + request + " to " + result.getArtifact().getFile() + " from " + result.getRepository());
        CollectRequest colReq = new CollectRequest();
        colReq.setRoot(new Dependency(result.getArtifact(), "runtime"));
        colReq.setRepositories(resources.getRemoteRepos());
        DependencyRequest dr = new DependencyRequest(colReq, new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                return true;
            }
        });
        DependencyResult dependencyResult = resources.getRepoSystem().resolveDependencies(resources.getRepoSession(), dr);
        for (ArtifactResult ar : dependencyResult.getArtifactResults()) {
            this.dependencies.add(ar.getArtifact());
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public List<Artifact> getDependencies() {
        return this.dependencies;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public void setDependencies(List<Artifact> dependencies) {
        this.dependencies = dependencies;
    }
}

