/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.plugin;

import java.text.SimpleDateFormat;
import org.eclipse.aether.artifact.Artifact;
import uno.anahata.mapacho.common.app.MapachoApplication;
import uno.anahata.mapacho.common.app.MapachoArtifact;
import uno.anahata.mapacho.plugin.AbstractResource;

public class JarResource
extends AbstractResource {
    private String os = "";
    private String arch = "";
    private String locale = "";
    private boolean nativelib = false;

    public MapachoArtifact toMapachoArtifact() {
        return this.toMapachoArtifact(null, this.getArtifact());
    }

    public void addAllDependenciesToClassPath(MapachoApplication parent) {
        for (Artifact a : this.getDependencies()) {
            MapachoArtifact ma = this.toMapachoArtifact(parent, a);
            parent.getClasspath().add(ma);
        }
    }

    public MapachoArtifact toMapachoArtifact(MapachoApplication parent, Artifact a) {
        String name = a.getGroupId() + "-" + a.getArtifactId();
        String ver = a.getVersion();
        if (a.isSnapshot() && ver.contains("SNAPSHOT")) {
            String date = new SimpleDateFormat("yyyyMMdd.HHmmss").format(a.getFile().lastModified());
            ver = ver.replace("SNAPSHOT", date + "-LMR");
        }
        MapachoArtifact ma = new MapachoArtifact(parent, name, this.os, this.arch, this.locale, ver, this.nativelib, a.getFile());
        return ma;
    }

    public String getOs() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean isNativelib() {
        return this.nativelib;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setNativelib(boolean nativelib) {
        this.nativelib = nativelib;
    }
}

