/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.plugin;

import java.io.File;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.WriterFactory;
import uno.anahata.mapacho.client.JavaFxDeployer;
import uno.anahata.mapacho.client.MapachoDownloadServiceListener;
import uno.anahata.mapacho.client.MapachoPreloader;
import uno.anahata.mapacho.client.TcpSocketPreloaderProxy;
import uno.anahata.mapacho.common.app.MapachoArtifact;
import uno.anahata.mapacho.plugin.JarResource;
import uno.anahata.mapacho.plugin.JnlpBase;
import uno.anahata.mapacho.plugin.MapachoMojo;
import uno.anahata.mapacho.plugin.Packager;

public class JnlpFile
extends JnlpBase {
    private String outputFilename;
    private VelocityEngine engine = new VelocityEngine();
    private Template velocityTemplate;
    private MapachoMojo resources;
    private Packager packager;

    private void loadDefaults(JnlpBase defaults) {
        if (defaults != null) {
            if (this.displayName == null) {
                this.displayName = defaults.getDisplayName();
            }
            if (this.metaInfApplicationName == null) {
                this.metaInfApplicationName = defaults.getMetaInfApplicationName();
            }
            if (this.splash == null) {
                this.splash = defaults.getSplash();
            }
            if (this.mainClass == null) {
                this.mainClass = defaults.getMainClass();
            }
            if (this.preloaderClass == null) {
                this.preloaderClass = defaults.getPreloaderClass();
            }
            if (this.displayVersion == null) {
                this.displayVersion = defaults.getDisplayVersion();
            }
            if (this.displayVersion == null) {
                this.displayVersion = this.resources.getProject().getVersion();
            }
            if (this.jre == null) {
                this.jre = defaults.getJre();
            } else if (defaults.getJre() != null) {
                if (StringUtils.isBlank((String)this.jre.getVer())) {
                    this.jre.setVer(defaults.getJre().getVer());
                }
                if (StringUtils.isBlank((String)this.jre.getBuild())) {
                    this.jre.setBuild(defaults.getJre().getBuild());
                }
                if (StringUtils.isBlank((String)this.jre.getHash())) {
                    this.jre.setHash(defaults.getJre().getHash());
                }
                if (StringUtils.isBlank((String)this.jre.getArch())) {
                    this.jre.setArch(defaults.getJre().getArch());
                }
                if (StringUtils.isBlank((String)this.jre.getOs())) {
                    this.jre.setOs(defaults.getJre().getOs());
                }
            }
            if (this.jvmArgs == null) {
                this.jvmArgs = defaults.getJvmArgs();
            }
            this.arguments.addAll(defaults.getArguments());
            if (this.templateFilename == null) {
                this.templateFilename = defaults.getTemplateFilename();
            }
            this.jarResources.addAll(defaults.getJarResources());
        }
        if (this.splash == null) {
            this.splash = "/images/splash-screen.png";
        }
        if (this.preloaderClass == null) {
            this.preloaderClass = TcpSocketPreloaderProxy.class.getName();
        }
        if (this.metaInfApplicationName == null) {
            System.out.println("metaInfApplicationName was not set, assuming " + this.resources.getProject().getArtifactId());
            this.metaInfApplicationName = this.resources.getProject().getArtifactId();
        }
        if (this.displayName == null) {
            this.displayName = this.metaInfApplicationName;
        }
    }

    public void execute(MapachoMojo resources) throws Exception {
        this.resources = resources;
        this.loadDefaults(resources.getJnlpBase());
        for (JarResource jarResource : this.jarResources) {
            jarResource.resolve(resources);
        }
        this.packager = new Packager(this);
        this.generateJNLP();
    }

    public String getOutputFileName() {
        if (StringUtils.isBlank((String)this.outputFilename)) {
            return FilenameUtils.getBaseName((String)this.templateFilename) + ".jnlp";
        }
        return this.outputFilename;
    }

    public String getSerializedDescriptorFileName() {
        return this.getDescriptorId() + ".ser";
    }

    public String getDescriptorId() {
        String outputFileName = this.getOutputFileName();
        return FilenameUtils.getBaseName((String)outputFileName);
    }

    private void generateJNLP() throws Exception {
        MavenProject project = this.resources.getProject();
        String source = project.getBasedir() + "/src/main/jnlp";
        Properties properties = new Properties();
        properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
        properties.setProperty("file.resource.loader.path", source);
        this.engine.init(properties);
        System.out.println("Loading template: " + this.templateFilename);
        this.velocityTemplate = this.engine.getTemplate(this.templateFilename, "UTF-8");
        VelocityContext context = this.createAndPopulateContext(project, this.packager.getLauncher(), this.packager.getPreloader());
        File jnlp = new File(this.resources.getWorkingDirectory(), this.getOutputFileName());
        System.out.println("Generating JNLP " + jnlp);
        try (Writer writer = WriterFactory.newWriter((File)jnlp, (String)"UTF-8");){
            this.velocityTemplate.merge((Context)context, writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new Exception("Could not generate the template " + this.velocityTemplate.getName() + ": " + e.getMessage(), e);
        }
    }

    protected VelocityContext createAndPopulateContext(MavenProject mavenProject, MapachoArtifact launcher, MapachoArtifact preloader) {
        VelocityContext context = new VelocityContext();
        String deps = "\n      <!-- Mapacho generated Dependencies -->\n\t" + launcher.getJnlpDependencyString("lib", true, null);
        String splashURL = "$$context" + this.packager.getApp().getSplash();
        StringBuilder propsStringBuilder = new StringBuilder();
        propsStringBuilder.append("\n      <!-- Mapacho generated JNLP properties -->");
        JnlpFile.appendJnlpProp(propsStringBuilder, "packEnabled", "true");
        JnlpFile.appendJnlpProp(propsStringBuilder, "versionEnabled", "true");
        JnlpFile.appendJnlpProp(propsStringBuilder, "mapacho.descriptor", this.getDescriptorId());
        JnlpFile.appendJnlpProp(propsStringBuilder, "mapacho.descriptor.timestamp", this.resources.getBuildTimestamp());
        JnlpFile.appendJnlpProp(propsStringBuilder, "mapacho.codebase", "$$codebase");
        JnlpFile.appendJnlpProp(propsStringBuilder, "mapacho.context", "$$context");
        JnlpFile.appendJnlpProp(propsStringBuilder, "mapacho.splash", splashURL);
        context.put("dependencies", (Object)deps);
        context.put("descriptor", (Object)this.getDescriptorId());
        context.put("properties", (Object)propsStringBuilder.toString());
        context.put("splash", (Object)splashURL);
        context.put("project", (Object)mavenProject.getModel());
        context.put("displayName", (Object)this.displayName);
        context.put("displayVersion", (Object)this.displayVersion);
        context.put("informationTitle", (Object)mavenProject.getModel().getName());
        context.put("informationDescription", (Object)mavenProject.getModel().getDescription());
        if (mavenProject.getModel().getOrganization() != null) {
            context.put("informationVendor", (Object)mavenProject.getModel().getOrganization().getName());
            context.put("informationHomepage", (Object)mavenProject.getModel().getOrganization().getUrl());
        }
        context.put("mainClass", (Object)JavaFxDeployer.class.getName());
        context.put("progressClass", (Object)MapachoDownloadServiceListener.class.getName());
        context.put("preloaderClass", (Object)MapachoPreloader.class.getName());
        return context;
    }

    private static void appendJnlpProp(StringBuilder sb, String key, String val) {
        sb.append("\n      <property name=\"jnlp." + key + "\" value=\"").append(val).append("\" />");
    }

    public VelocityEngine getEngine() {
        return this.engine;
    }

    public Template getVelocityTemplate() {
        return this.velocityTemplate;
    }

    public MapachoMojo getResources() {
        return this.resources;
    }

    public Packager getPackager() {
        return this.packager;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public void setEngine(VelocityEngine engine) {
        this.engine = engine;
    }

    public void setVelocityTemplate(Template velocityTemplate) {
        this.velocityTemplate = velocityTemplate;
    }

    public void setResources(MapachoMojo resources) {
        this.resources = resources;
    }

    public void setPackager(Packager packager) {
        this.packager = packager;
    }
}

