/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import uno.anahata.mapacho.common.io.MapachoIOUtils;
import uno.anahata.mapacho.plugin.JarResource;
import uno.anahata.mapacho.plugin.MapachoMojo;

public class KeystoreJarResource
extends JarResource {
    private String keystore;
    private File keystoreFile;

    @Override
    public void resolve(MapachoMojo resources) throws Exception {
        super.resolve(resources);
        File artifactFile = this.getArtifact().getFile();
        if (this.keystore == null) {
            this.keystoreFile = artifactFile;
        } else {
            System.out.println("<keystore> entry specified inside <keystoreResource> will assume keystoreResource is zip and will try to  find " + this.keystore + " inside jar " + artifactFile);
            Path temp = Files.createTempFile(this.keystore, artifactFile.getName(), new FileAttribute[0]);
            Files.delete(temp);
            try (FileSystem zipfs = MapachoIOUtils.getZipFileSystem((File)artifactFile);){
                Path pathInJar = zipfs.getPath(this.keystore, new String[0]);
                if (!Files.exists(pathInJar, new LinkOption[0])) {
                    throw new IOException("Couldn't find " + this.keystore + " in " + artifactFile);
                }
                System.out.println("Copying " + this.keystore + " in " + pathInJar + " to " + temp);
                Files.copy(pathInJar, temp, new CopyOption[0]);
            }
            temp.toFile().deleteOnExit();
            this.keystoreFile = temp.toFile();
            System.out.println("Setting lastmod " + temp + " to " + artifactFile.lastModified());
            this.keystoreFile.setLastModified(artifactFile.lastModified());
        }
        resources.getSign().setKeystore(this.keystoreFile.toString());
    }

    public String getKeystore() {
        return this.keystore;
    }

    public File getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setKeystoreFile(File keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeystoreJarResource)) {
            return false;
        }
        KeystoreJarResource other = (KeystoreJarResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$keystore = this.getKeystore();
        String other$keystore = other.getKeystore();
        if (this$keystore == null ? other$keystore != null : !this$keystore.equals(other$keystore)) {
            return false;
        }
        File this$keystoreFile = this.getKeystoreFile();
        File other$keystoreFile = other.getKeystoreFile();
        return !(this$keystoreFile == null ? other$keystoreFile != null : !((Object)this$keystoreFile).equals(other$keystoreFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeystoreJarResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keystore = this.getKeystore();
        result = result * 59 + ($keystore == null ? 43 : $keystore.hashCode());
        File $keystoreFile = this.getKeystoreFile();
        result = result * 59 + ($keystoreFile == null ? 43 : ((Object)$keystoreFile).hashCode());
        return result;
    }

    public String toString() {
        return "KeystoreJarResource(keystore=" + this.getKeystore() + ", keystoreFile=" + this.getKeystoreFile() + ")";
    }
}

