/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.jar.Pack200;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.jarsigner.JarSigner;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerUtil;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import uno.anahata.mapacho.common.app.MapachoApplication;
import uno.anahata.mapacho.common.app.MapachoArtifact;
import uno.anahata.mapacho.common.io.MapachoIOUtils;
import uno.anahata.mapacho.plugin.JarResource;
import uno.anahata.mapacho.plugin.JnlpBase;
import uno.anahata.mapacho.plugin.JnlpFile;
import uno.anahata.mapacho.plugin.SignConfig;

@Mojo(name="mapacho", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, aggregator=true)
public class MapachoMojo
extends AbstractMojo {
    public String buildTimestamp = new SimpleDateFormat("yyyyMMdd.HHmmss").format(new Date());
    @Component
    private MavenProject project;
    @Parameter
    private JnlpBase jnlpBase;
    @Parameter(required=true)
    private List<JnlpFile> jnlpFiles;
    @Parameter(required=true)
    private SignConfig sign;
    @Component
    private JarSigner jarSigner;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    private final Map<String, MapachoArtifact> packagedLaunchersByApplicationName = new HashMap<String, MapachoArtifact>();
    private final Map<String, MapachoArtifact> packagedPreloadersByApplicationName = new HashMap<String, MapachoArtifact>();
    private final Set<File> packagedLib2Artifacts = new HashSet<File>();
    private MapachoArtifact preloaderMapachoArtifact;

    public File getWorkingDirectory() {
        return new File(this.project.getBuild().getDirectory(), "mapacho");
    }

    public File getFinalDirectory() {
        File to = new File(this.getProject().getBuild().getDirectory(), this.getProject().getBuild().getFinalName() + File.separator + "mapacho");
        return to;
    }

    public void execute() throws MojoExecutionException {
        System.out.println("*************** Mapacho Plugin Starts **********");
        long ts = System.currentTimeMillis();
        System.out.println("Init Code Signing");
        try {
            this.sign.init(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Exception initializing SignConfig", e);
        }
        System.out.println("Code Signing initialized");
        System.out.println("mojo ver " + this.mojo.getVersion());
        System.out.println("Base Dir: " + this.project.getBasedir() + " context = " + super.getPluginContext());
        this.jnlpFiles.parallelStream().forEach(jnlpFile -> {
            try {
                jnlpFile.execute(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Excpetion generating jnlp", e);
            }
        });
        try {
            FileUtils.copyDirectory((File)this.getWorkingDirectory(), (File)this.getFinalDirectory());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Expcetion copying directory structure", e);
        }
        ts = System.currentTimeMillis() - ts;
        System.out.println("           `     `  `...`              `                               \n                      `   ```++/o+/:-`    `   ``      `            `            \n                    ``  `++`/s.oosso+o:`       `        `        `.             \n                     ` ``+s-/+-:/yo.-yds/`     `-++:.    ` `           `        \n                      ````-///++o+--sdmmhs:.   -sssoo:`    `  ``       ``       \n                  ` `` -/++os/syso/+soshmmhso/::ososhho:.   /so:.   `` `        \n            ``  ` ``  -o+-..-/s+:.:oy+oydddhddddhhdddddso+:/ysyo:`       `      \n                   `  .++/...-::+shdmmmmmNNmmmmmmNNNmmmmmdhhdhso-`   `  `. ` `` \n                      ``oydyyyhdmmmmmNNNNNNmmmmmmmNmNNNNNNNNmmhyss+:.`` `` ```  \n               .--.` `.-syddmmmmmmmmNNNmmddddmmdmmmmNNNNNNNNNNNNmmdys+-```````  \n              -+ooos++shhdmmmmmmmmmmddddmmddddmmmdddNNNNNNNNNNNNNNNmdhs+.`` ``` \n              `...-syshdmmmmmmmmmmmmdmmhhdmmmmdddmNmNNNNNNNNNNNNNNNNNmdss-`   ``\n               ` `:sydmmmmmmmmmmmmmmmdyddmdhddddyodNNNNNNNNNddddmmNNNNNmsy.`````\n           `.   -oyhmmmmmmmmmmmmmmmmm+yhmyyyymNmhdmNNNNNNNNNhNNmddhdNNNNmss`````\n         `-+/-`/yhdmmmmmmmmmmmmmmmmmdosddhyyhmddNNNNNNNNNNNNyyyhdddyydNNNmh`````\n         `/o++shhmmmmmmmmmmmmmmmmddmmmmmdddddmmmNNNNNNNNNNNNhyhmhhmNmshNNNh.````\n          `.-yshmmmmmmmmmmmmmmmmhdmmmmmmmmmmmdddddhhNNNNNNNNmmdhyyshNmyhNNy.````\n           `:syddmmmmmmmmmmmmmmhmmmmmmmmmmNmhmhhhdmdNmhddNNNmydmshdhhNhhmdo`````\n          -/shddmmmmmmmmmmmmmmhdmmmmmmmmmmmmdddddddddyyddmmmNmsddydmdhhdmy-`````\n          ooyddmmmmmmmmmmmmmmdhmmmmmmmmmmmmmmdddddmmNmhohdddhmmymyddyomhh/````.`\n        `.+sdddmmmmmmmmmmmmmmhmmmmmmmmmmmdyydhdosyssyyyyhhdmNddddmNNNhsy.````.``\n      ` .+oddmmmmmmmmmmmmmmmmhmmmmmmmmmhddhhmddhhhsmdymmydsssmhmNNNNNNy:````````\n     ` `:odddddmmmmmmmmmmmmmmhmmmmmmdhhddmmmmNNNNNddyhhhyhyyyymhmNNNNNh:````````\n  `  ``/+sddddmmmmmmmmmmmmmmhmmmmdhhddmmmmmmmNNNNNNNNmmmNNNNmdhmyNNNNNho``````.`\n     ``+oddmmmmmmmmmmmmmmmmmymmhyshmmmmmmmNmmNNNNNNNNNNNNNNNNNmyyhNNNNys``.`````\n      :ooddddmmmmmmmmmmmmmmdhhyyhmmmmmmmmmmNNNNNNNNNmNNNNNNNNNNydhNNNNhy````````\n     `:+syddmmmmmmmmmmmmmmmhdddhhmmmmmmmmNNNNmNmNmNNNNNNNNNNNNNmhmhNNNyy``.`````\n     .//yhyhdmmmmmmmmmmmmmmmddmyhhdmmmmmmmNNNNmmmNNNNNNNNNNNNNNNmysdNNys````````\n    ./sshyddhhhdddmmmmhhhhydmmhdhhhhdmmdmmmmmNNNmNNNNNNNNNNNNNNNNmhhmNyo..``` ``\n     -s/ydhhhdddhyyddydmmmmoyhmhmhdmdh/osyoshyhhhhhmmdmNNNNNNNNNNmhhydy-```` ```\n      ++::shddhhyhmmydmmmms:`+yhhmmhdmmsoyyohssh+mm+om+syyhosyyhyodNdsh````   ``\n      :odho/:/+sy+omymmmmds-  .oysmmdhmmmhhhhhhhoyhssyshsys+oodyhdhy+:``````  ``\n      /+dddddhyo+/smymmmmyhs`  `:symmmhdmmmmmmmmdhyhdddhhhdNNdymd+-``````````  `\n      oshdddddmmdyymymmmmsyyy+:---:sdmmmhddmmmmmmmmymmmmNNNdhmdo-.````````````  \n     `+ysdddddmddsydshmmhoyyddssyy/-:sdmmmmddddmmmmhmmmmmddmds-``````````.````  \n      .oosdddddddoshhsdmy+`yyyyyso/:``:sdmmmmmmdddydddddmmho-`````.`````````` ``\n       `oyydddddyy+yoyhyoo -oyyshs-   ``:ohdmmmmmmmmmmdds/.```````````````` `` `\n        :hshdddydsoyysysys  `+o-.-.  `````./ooshdhyyso/-.```````    ``` `  `  ``\n        `/ysdddyyhdoydmdds   :yss+:-```````````-/:/osssoo````   ````````````````\n         `+yydddmmmhhmmmmo`  ohysysh/````````.:+yhyysooyy-`    `````````````````\n`         `/yymmmmmmhhmmmh- `odsshyyo: `.:+syysddhhyyssyss.   ``````````````````\n`   `      `ohhdmmmmmsdmmms-/ommhsyy-./yhddhhymdsyhddmydyys/.```..`````````````.\n    -`     `/yyhmdmmh-/dmmdyysdh+-.:/shhhddmmmmmmmmddhdmmmmmy+:....`````````````\n`   ++`  ` ``/sysys+..symmmdsdy:`.+ddshyyhmhsddddmmmmmdhmmddmdy+-::-````````````\n    os/   `` `.//-:/ohmdymmmddo.:ymdhsyyhsyyydddhyhddmmdhdhhhhdyysyys:``````````\n    oso  ``    `+yydddhyyymmmmhssddymmhyyhdshhysohydsmmmmsmmdhddhsysdo.`````` ``\n`   .sy` ``   ` `/yhsyyyhdhdddhhhhdyhdmmmyhyhsssshymhmmNNsmNNhyhhydso.``````````\n```  .++-`   `` `-+yyydmmmmddddhddyhdyshhhhsodhhhyhhhmNNNdhmmyhdNhys.....`.`` ``\n  `   `+o+.`  `    -ohydmmmmmmsdmmdyy++oshmmdhdhhhyymmNNmm:/:-:ohss//``.``.   ``\n       `/yo.        `oyhhdmmmmmhydyhohsyyhmdsyhssoysmmNNNhshhy/.-s:.-`````   ``.\n         :so.       .-:+sshdmmmmmhsoyhsmmmmdhddsoshshmmNdsmNNNmo/y`-.`..-`  ````\n          os/           `-oyhdmmmmmdhhyhddhhhdhydsyddmmy:hmmmmd++:`.``.-.. ```.`\n          :yy.             -hshdmmmmmmmdhhddyhddhhhdhhd+`-mmmys/-`-`:.:..`  ````\n     `    -yh:              oymdshdmmmmmmmmmmdhhddhdmmmo`.dsoo-`````.:````` ````\n    `.    `oho             `shmmsmdhhhdddmmmmmmmmmmmmmd:.:/:.``````````.-```````\n          `.sy-     ` `    `odmmsmmmmmdo+sosoosyyyhyoo+-`````````````````````` `\n          ``:ss       `     ohmmomddddmys:-----:/:--.```````````````````````````\n          -`.ss           ``+smmodmddmdyy:  ``.-:////```````````````````````````\n            `ys  ` `.`   -ssyodmshddddmhy+.:+sssssys/` `````````````````````````\n     ``    .`hy` `.`-`.:/syhyyyhyydddddmysydymmdhsy+-` `` ``````````````````````\n    `       /ss ..:.:o+/hhyshyshhdmmddmmhhds+ossysyo+- `````````````````````````\n   .:      .ho:.  -/+yosoyyo:-sddsmmmmmmmho-  -sho/``` `````````````````````````\n  `   .` `:ss.`--`` -sds/sdy/ :yssommmmmmdo+` `````    `````````````````````````\n      ` `-so`  `.`  `:s+.-o+```+:.-sdmmmmdy/+:` +.:/`  `````````` ``````````````\n        /yo`.  ` ```  .`  `     /ymdhhmdmmmh-o-`ooys`  ``````````` `````````````\n      `+os` `                   `+hmmdhdmmmmyss+ymdho:- `   ``  ``  ````````````\n     -ooy.                     `./sshhhsmmmmmhshmhshydo-`          `` ``````````\n    -s:h+                 ```./o+shhmsyyhmmmmmdmm+hhoysy+`         `  `  ```````\n   `oo+d.                 `:oyoyossyssyhsymmmmmdmyosossy+`     `      ``` ``````\n   /oooy                  -//o+ydsydh+ssysymmmddmmys-`.-`      ````   `      ```\n  `oysss     ``            `..+os/oo+`:o/+/dmmdddmmyo.          ``    ``     ```\n  /oysso     `                .-. ```  /...ommdddmmdyo-       `                `\n  +hysoo           `     `          `.-+ohhyhmmmmmmmdyo-                `   `` `\n `ohysos           ``` `````    ..:+oohdhhhdsdmdmmmmmhy+..-:`              ` `` \n .ohhsss           `````````` :+shyssshdmmyssyddddmmmmyhoodo:                .` \n `ohhshs.              `````` `-sy+ysysohy+ysdddddddddyshmmho`                  \n  +hhoho:               ````    osyhyyyy+/sdsdddddddmhhdysdmyo.               ` \n  /yhsys/                ` `    //+oshhs.:syyddmddddmdyososhyh+                 \n  .ohhsh+`                ` `   `` `:+o/`oysddddddddddoooyhssh+                 \n   +shsys/                           `..+shsmddddddddyyoyssoss:                 \n   .ohhoho:                        ``./+ohsdmdddddddhsy+-..`.:`   `` `        ``\n    -ohhsyo:`                    `-o+ossyshmmdddmmmdyy/`          ``  -`        \n     :shhsso//:.`            `.-/+osyddyydmmmmmmmmhyh+.             `           \n      /yhhysoooo//-.``   ``-:///shdddyydddmmmmmmdyys:.              `           \n      `/yhhhyssoo+o+++-:/:/+// `yhyyhddddddddddhyyo.                          ` \n       `/yhhhhhhyssoo++oyhyo++:+yhddddddddddhs+os/`                           ` \n        `/yhhhhhhhhhhyyyyyhhhdddddddddhdhhy/`-+/.                          ` `  \n          :yhhhhhhhhddddddhhdddddddddhyssooo--`                                `\n           -oyhhhhhhhhhhdhhhdddhhyso++ooo/.          `         `          ``  ``\n            `:+oossyyyyyyssso++++o+//:-`                                  ``  ``\n               `.-:/++++/+////:-.`                                     .    ` ``\n                   `   `                                    .    `            ` ");
        System.out.println("total Mapacho time " + ts + " ms.");
        System.out.println("*************** Mapacho Plugin Ends **********");
    }

    public synchronized void packageLib2Artifacts(MapachoApplication app) throws Exception {
        app.getClasspath().parallelStream().forEach(ma -> {
            File target = new File(this.getMapachoLibDir(), ma.getJarFileName());
            if (!this.packagedLib2Artifacts.contains(target) && !target.exists()) {
                try {
                    System.out.println("Copying " + ma.getFile().getName() + " to " + this.getMapachoLibDir());
                    FileUtils.copyFile((File)ma.getFile(), (File)target);
                    if (JarSignerUtil.isArchiveSigned((File)target)) {
                        System.out.println("Removing signature from " + target.getName());
                        JarSignerUtil.unsignArchive((File)target);
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    public synchronized MapachoArtifact packagePreloader(String applicationName) throws Exception {
        if (this.packagedPreloadersByApplicationName.containsKey(applicationName)) {
            return this.packagedPreloadersByApplicationName.get(applicationName);
        }
        JarResource mapacho_client_jar_without_deps = new JarResource();
        mapacho_client_jar_without_deps.setGroupId(this.getMojo().getGroupId());
        mapacho_client_jar_without_deps.setArtifactId("mapacho-client");
        mapacho_client_jar_without_deps.setVersion(this.getMojo().getVersion());
        mapacho_client_jar_without_deps.resolve(this);
        this.preloaderMapachoArtifact = mapacho_client_jar_without_deps.toMapachoArtifact();
        this.packagePureJWSArtifact(this.preloaderMapachoArtifact, applicationName);
        this.packagedPreloadersByApplicationName.put(applicationName, this.preloaderMapachoArtifact);
        return this.preloaderMapachoArtifact;
    }

    public synchronized MapachoArtifact packageLauncher(@NonNull String applicationName) throws Exception {
        if (applicationName == null) {
            throw new NullPointerException("applicationName");
        }
        if (this.packagedLaunchersByApplicationName.containsKey(applicationName)) {
            return this.packagedLaunchersByApplicationName.get(applicationName);
        }
        JarResource mapachoJarWithDependencies = new JarResource();
        mapachoJarWithDependencies.setGroupId(this.getMojo().getGroupId());
        mapachoJarWithDependencies.setArtifactId("mapacho-client");
        mapachoJarWithDependencies.setVersion(this.getMojo().getVersion());
        mapachoJarWithDependencies.setClassifier("jar-with-dependencies");
        mapachoJarWithDependencies.resolve(this);
        String mapachoVersion = mapachoJarWithDependencies.toMapachoArtifact().getVersion();
        String launcherName = applicationName.replaceAll("[^a-zA-Z0-9.-]", "-").toLowerCase();
        MapachoArtifact launcherMapachoArtifact = new MapachoArtifact();
        launcherMapachoArtifact.setName(launcherName + "-mapacho");
        launcherMapachoArtifact.setVersion(mapachoVersion + "-" + this.getSign().getUniqueString().hashCode());
        launcherMapachoArtifact.setFile(mapachoJarWithDependencies.getArtifact().getFile());
        String cacheKey = launcherMapachoArtifact.getJarFileName();
        File cachedFile = new File(MapachoMojo.getCacheDirectory(), cacheKey);
        if (cachedFile.exists()) {
            System.out.println("Signed launcher already in cache " + cachedFile);
            File jarInLibDir = new File(this.getJnlpLibDir(), launcherMapachoArtifact.getJarFileName());
            FileUtils.copyFile((File)cachedFile, (File)jarInLibDir);
            launcherMapachoArtifact.setFile(jarInLibDir);
        } else {
            System.out.println("Signed launcher not in cache: " + cachedFile);
            this.packagePureJWSArtifact(launcherMapachoArtifact, applicationName);
            FileUtils.copyFile((File)launcherMapachoArtifact.getFile(), (File)cachedFile);
            System.out.println("Copied signed launcher to cache: " + cachedFile);
        }
        this.packagedLaunchersByApplicationName.put(applicationName, launcherMapachoArtifact);
        return launcherMapachoArtifact;
    }

    private void packagePureJWSArtifact(MapachoArtifact mapachoArtifact, String applicationName) throws Exception {
        File jarInLibDir = new File(this.getJnlpLibDir(), mapachoArtifact.getJarFileName());
        if (jarInLibDir.exists()) {
            System.out.println("Copying Pure JWS jar arleady present in " + jarInLibDir);
            return;
        }
        System.out.println("Copying Pure JWS jar to to " + jarInLibDir);
        FileUtils.copyFile((File)mapachoArtifact.getFile(), (File)jarInLibDir);
        mapachoArtifact.setFile(jarInLibDir);
        System.out.println("Mapacho Jar With Deps copied to " + jarInLibDir + " size = " + FileUtils.byteCountToDisplaySize((long)jarInLibDir.length()));
        this.processManifest(jarInLibDir, applicationName);
        MapachoIOUtils.putInJar(null, (File)jarInLibDir, (String)"META-INF/INDEX.LIST");
        File temp = new File(jarInLibDir.getParent(), jarInLibDir.getName() + ".pack");
        System.out.println("Launch jar before repack" + jarInLibDir + " size" + jarInLibDir.length());
        long ts = System.currentTimeMillis();
        System.out.println("Packing " + jarInLibDir + " to " + temp);
        try (FileOutputStream fos = new FileOutputStream(temp);){
            Pack200.newPacker().pack(new JarFile(jarInLibDir), (OutputStream)fos);
        }
        jarInLibDir.delete();
        System.out.println("Packed " + temp + " size=" + temp.length() + " unpacking...");
        var8_7 = null;
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarInLibDir));){
            Pack200.newUnpacker().unpack(temp, jos);
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        temp.delete();
        ts = System.currentTimeMillis() - ts;
        System.out.println("repack took " + ts + "ms. Launch jar after repack" + jarInLibDir + " size=" + jarInLibDir.length());
        JarSignerRequest signRequest = this.getSign().createSignRequest(jarInLibDir, jarInLibDir);
        this.getSign().run(signRequest);
        System.out.println("verifying signed jar " + jarInLibDir);
        JarSignerRequest verifyRequest = this.getSign().createVerifyRequest(jarInLibDir);
        this.getSign().run(verifyRequest);
    }

    private void processManifest(File jar, String applicationName) throws IOException {
        HashMap<String, String> entries = new HashMap<String, String>();
        entries.put("Application-Name", applicationName);
        entries.put("Codebase", "*");
        entries.put("Permissions", "all-permissions");
        Manifest newMainfest = MapachoMojo.createManifest(jar, entries);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        newMainfest.write(baos);
        MapachoIOUtils.putInJar((InputStream)new ByteArrayInputStream(baos.toByteArray()), (File)jar, (String)"META-INF/MANIFEST.MF");
    }

    private static Manifest createManifest(File jar, Map<String, String> manifestentries) throws IOException {
        try (JarFile jarFile = new JarFile(jar);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null || manifest.getMainAttributes().isEmpty()) {
                manifest = new Manifest();
                manifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            }
            if (manifest.getMainAttributes().containsKey(Attributes.Name.CLASS_PATH)) {
                System.out.println("Removing " + Attributes.Name.CLASS_PATH + " MANIFEST entry from " + jar);
                manifest.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
            }
            Set<Map.Entry<String, String>> entrySet = manifestentries.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                manifest.getMainAttributes().putValue(entry.getKey(), entry.getValue());
            }
            System.out.println("-----Removing entries with signatures (if any)-------");
            block10: for (String string : new ArrayList<String>(manifest.getEntries().keySet())) {
                Attributes atts = manifest.getEntries().get(string);
                for (Map.Entry<Object, Object> entry : atts.entrySet()) {
                    if (!entry.getKey().toString().toLowerCase().contains("digest")) continue;
                    Attributes ret = manifest.getEntries().remove(string);
                    System.out.println("Removed " + ret.keySet() + " " + ret.values());
                    continue block10;
                }
            }
            System.out.println("Final Manifest for " + jar);
            System.out.println("------ Main attributes-----");
            for (Object object : manifest.getMainAttributes().keySet()) {
                System.out.println(object + " = " + manifest.getMainAttributes().get(object));
            }
            System.out.println("-----Entries-------");
            for (String string : manifest.getEntries().keySet()) {
                System.out.println(string + " = " + manifest.getEntries().get(string).values());
            }
            Manifest manifest2 = manifest;
            return manifest2;
        }
    }

    public File getJnlpLibDir() {
        return new File(this.getWorkingDirectory(), "lib");
    }

    public File getMapachoLibDir() {
        return new File(this.getWorkingDirectory(), "lib2");
    }

    public File getMapachoDescriptorsDir() {
        return new File(this.getWorkingDirectory(), "descriptors");
    }

    private static File getCacheDirectory() {
        File temp = FileUtils.getTempDirectory();
        File jwstemp = new File(temp, "anahata-mapacho-cache");
        if (!jwstemp.exists()) {
            System.out.println("Creating temp directory " + jwstemp);
            jwstemp.mkdirs();
        }
        return jwstemp;
    }

    public String getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public JnlpBase getJnlpBase() {
        return this.jnlpBase;
    }

    public SignConfig getSign() {
        return this.sign;
    }

    public JarSigner getJarSigner() {
        return this.jarSigner;
    }

    public RepositorySystem getRepoSystem() {
        return this.repoSystem;
    }

    public RepositorySystemSession getRepoSession() {
        return this.repoSession;
    }

    public List<RemoteRepository> getRemoteRepos() {
        return this.remoteRepos;
    }

    public MojoExecution getMojo() {
        return this.mojo;
    }

    public PluginDescriptor getPlugin() {
        return this.plugin;
    }

    public MapachoArtifact getPreloaderMapachoArtifact() {
        return this.preloaderMapachoArtifact;
    }
}

