/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.plugin;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SerializationUtils;
import uno.anahata.mapacho.common.app.MapachoApplication;
import uno.anahata.mapacho.common.app.MapachoArtifact;
import uno.anahata.mapacho.plugin.JarResource;
import uno.anahata.mapacho.plugin.JnlpFile;

public class Packager {
    private final JnlpFile jnlpFile;
    private MapachoApplication app;
    private final MapachoArtifact launcher;
    private MapachoArtifact preloader;

    public Packager(JnlpFile file) throws Exception {
        this.jnlpFile = file;
        this.installMapachoApplicationDescriptor();
        this.launcher = file.getResources().packageLauncher(file.getMetaInfApplicationName());
        file.getResources().packageLib2Artifacts(this.app);
    }

    private void installMapachoApplicationDescriptor() throws Exception {
        this.app = new MapachoApplication();
        this.app.setSplash(this.jnlpFile.getSplash());
        this.app.setPreloaderClass(this.jnlpFile.getPreloaderClass());
        this.app.setDisplayName(this.jnlpFile.getDisplayName());
        if (this.app.getDisplayName() == null) {
            this.app.setDisplayName(this.jnlpFile.getMetaInfApplicationName());
        }
        this.app.setDisplayVer(this.jnlpFile.getDisplayVersion());
        this.app.setJre(this.jnlpFile.getJre());
        this.app.setJvmArgs(this.jnlpFile.getJvmArgs());
        this.app.setMainClass(this.jnlpFile.getMainClass());
        this.app.setArguments(this.jnlpFile.getArguments());
        for (JarResource jr : this.jnlpFile.getJarResources()) {
            jr.addAllDependenciesToClassPath(this.app);
        }
        System.out.println(this.app);
        byte[] barr = SerializationUtils.serialize((Serializable)this.app);
        File targetInWebModule = new File(this.jnlpFile.getResources().getMapachoDescriptorsDir() + File.separator + this.jnlpFile.getSerializedDescriptorFileName());
        FileUtils.writeByteArrayToFile((File)targetInWebModule, (byte[])barr);
        System.out.println("Installing descriptor in web module" + targetInWebModule);
    }

    public MapachoApplication getApp() {
        return this.app;
    }

    public MapachoArtifact getLauncher() {
        return this.launcher;
    }

    public MapachoArtifact getPreloader() {
        return this.preloader;
    }
}

