/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerSignRequest;
import org.apache.maven.shared.jarsigner.JarSignerVerifyRequest;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.javatool.JavaToolRequest;
import org.apache.maven.shared.utils.cli.javatool.JavaToolResult;
import uno.anahata.mapacho.plugin.KeystoreJarResource;
import uno.anahata.mapacho.plugin.MapachoMojo;

public class SignConfig {
    private MapachoMojo resources;
    private File workDirectory;
    private boolean verbose;
    private String keystore;
    private KeystoreJarResource keystoreResource;
    private String storetype;
    private String storepass;
    private String keypass;
    private String alias;
    private String tsaLocation;

    public void init(MapachoMojo resources) throws Exception {
        this.resources = resources;
        if (this.keystoreResource != null) {
            this.keystoreResource.resolve(resources);
        }
    }

    public String getUniqueString() {
        File ksFile = this.keystoreResource != null ? this.keystoreResource.getArtifact().getFile() : new File(this.keystore);
        long keystoreLastMod = ksFile.lastModified();
        System.out.println("SignConfig.getUniqueString keystoreLastMod keystore file exists = " + ksFile.exists());
        System.out.println("SignConfig.getUniqueString keystoreLastMod = " + keystoreLastMod);
        String base = "sign_" + ksFile + "_" + keystoreLastMod + "_" + this.storetype + "_" + this.storepass.hashCode() + "_" + this.keypass.hashCode() + "_" + this.alias + "_" + this.tsaLocation + '}';
        System.out.println("SignConfig.getUniqueString = " + base);
        return base;
    }

    public JarSignerRequest createSignRequest(File jarToSign, File signedJar) {
        JarSignerSignRequest request = new JarSignerSignRequest();
        request.setAlias(this.getAlias());
        request.setKeypass(this.getKeypass());
        request.setKeystore(this.getKeystore());
        request.setStorepass(this.getStorepass());
        request.setStoretype(this.getStoretype());
        request.setWorkingDirectory(this.workDirectory);
        request.setVerbose(true);
        request.setArchive(jarToSign);
        request.setSignedjar(signedJar);
        request.setTsaLocation(this.getTsaLocation());
        return request;
    }

    public JarSignerRequest createVerifyRequest(File jarFile) {
        JarSignerVerifyRequest request = new JarSignerVerifyRequest();
        request.setCerts(true);
        request.setWorkingDirectory(this.workDirectory);
        request.setVerbose(false);
        request.setArchive(jarFile);
        return request;
    }

    public void run(JarSignerRequest request) throws Exception {
        long ts = System.currentTimeMillis();
        JavaToolResult result = this.resources.getJarSigner().execute((JavaToolRequest)request);
        CommandLineException exception = result.getExecutionException();
        if (exception != null) {
            throw new MojoExecutionException("Could not run " + request + " jar " + request.getArchive(), (Exception)exception);
        }
        int exitCode = result.getExitCode();
        if (exitCode != 0) {
            throw new MojoExecutionException("Could not run " + request + " on  ar " + request.getArchive() + ", use -X to have detail of error");
        }
        ts = System.currentTimeMillis() - ts;
        System.out.println(request.getClass().getSimpleName() + " on " + request.getArchive().getName() + " took " + ts + " m.");
    }

    public MapachoMojo getResources() {
        return this.resources;
    }

    public File getWorkDirectory() {
        return this.workDirectory;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public KeystoreJarResource getKeystoreResource() {
        return this.keystoreResource;
    }

    public String getStoretype() {
        return this.storetype;
    }

    public String getStorepass() {
        return this.storepass;
    }

    public String getKeypass() {
        return this.keypass;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getTsaLocation() {
        return this.tsaLocation;
    }

    public void setResources(MapachoMojo resources) {
        this.resources = resources;
    }

    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setKeystoreResource(KeystoreJarResource keystoreResource) {
        this.keystoreResource = keystoreResource;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setTsaLocation(String tsaLocation) {
        this.tsaLocation = tsaLocation;
    }
}

