/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package uno.anahata.mapacho.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;

/**
 *
 * @author pablo
 */
@WebServlet(name = "MapachoServlet", urlPatterns = "/mapacho/*")
@Slf4j
public class MapachoServlet extends HttpServlet {

    private JnlpFileHandler jnlpHandler;

    private JarHandler jarHandler;
    
    private JreHandler jreHandler;

    /**
     * Initialize servlet
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        jnlpHandler = new JnlpFileHandler(config.getServletContext());
        jarHandler = new JarHandler(config.getServletContext());
        jreHandler = new JreHandler(config.getServletContext());
    }

    /**
     * We handle get requests too - eventhough the spec. only requeres POST requests
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        
        String requestStr = request.getRequestURI();
        if (request.getQueryString() != null) {
            requestStr += "?" + request.getQueryString().trim();
        }
        
        log.info("Request string {}", requestStr);
        log.info("Method {}", request.getMethod());
        log.info("User-Agent {}", request.getHeader("User-Agent"));
        
        DownloadRequest dreq = new DownloadRequest(request);
        log.info("Download-Request {}", dreq);
        
        DownloadResponse dresp;
        if (dreq.isJnlp()) {
            log.info("Request is jnlp");
            dresp = jnlpHandler.getJnlpFileEx(dreq);
        } else if (dreq.isJar()) {
            log.info("Request is jar");
            dresp = jarHandler.getDownloadResponse(dreq);
            if (dresp == null) {
                response.sendError(HttpServletResponse.SC_NOT_FOUND);
                return;
            }
        } else if (dreq.isJRE()){
            log.info("Request is JRE");
            dresp = jreHandler.getDownloadResponse(dreq);
        } else {
            log.info("Request is file");
            dresp = new FileDownloadResponse(dreq);
        }
        
        log.info("Response is " + dresp);
        dresp.sendResponse(dreq, response);

    }
    
    public static File getCacheDirectory() {
        File temp = FileUtils.getTempDirectory();
        File jwstemp = new File(temp, "anahata-mapacho-cache");
        if (!jwstemp.exists()) {
            log.info("Creating temp directory " + jwstemp);
            jwstemp.mkdirs();
        }
        return jwstemp;
    }

}
