/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.servlet;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uno.anahata.mapacho.common.app.MapachoArtifact;
import uno.anahata.mapacho.common.os.OSUtils;
import uno.anahata.mapacho.common.runtime.JRE;
import uno.anahata.mapacho.servlet.MapachoServlet;

public class DownloadRequest {
    private static final Logger log = LoggerFactory.getLogger(DownloadRequest.class);
    private String path = null;
    private String requestedVersion = null;
    private String currentVersion = null;
    private String[] os = null;
    private String[] arch = null;
    private String[] locale = null;
    private String[] knownPlatforms = null;
    private String query = null;
    private String agent = null;
    private boolean isPlatformRequest = false;
    private Date ifModifiedSince;
    private String encoding = null;
    private HttpServletRequest httpRequest = null;
    public static final String ACCEPT_ENCODING = "accept-encoding";

    public DownloadRequest(HttpServletRequest request) {
        this.httpRequest = request;
        this.path = request.getRequestURI();
        this.encoding = request.getHeader(ACCEPT_ENCODING);
        String context_path = request.getContextPath();
        if (context_path != null) {
            this.path = this.path.substring(context_path.length());
        }
        if (this.path == null) {
            this.path = request.getServletPath();
        }
        if (this.path == null) {
            this.path = "/";
        }
        this.path = this.path.trim();
        if (this.path.endsWith("/")) {
            this.path = this.path + "launch.jnlp";
        }
        this.requestedVersion = this.getParameter(request, "version-id");
        this.currentVersion = this.getParameter(request, "current-version-id");
        this.os = this.getParameterList(request, "os");
        this.arch = this.getParameterList(request, "arch");
        this.locale = this.getParameterList(request, "locale");
        this.knownPlatforms = this.getParameterList(request, "known-platforms");
        String platformVersion = this.getParameter(request, "platform-version-id");
        boolean bl = this.isPlatformRequest = platformVersion != null;
        if (this.isPlatformRequest) {
            this.requestedVersion = platformVersion;
        }
        this.query = request.getQueryString();
        long date = request.getDateHeader("If-Modified-Since");
        if (date != -1L) {
            date = date / 1000L * 1000L;
            this.ifModifiedSince = new Date(date);
        }
        this.agent = request.getHeader("User-Agent");
    }

    public boolean isJar() {
        return this.path.endsWith(".jar") || this.path.endsWith(".jar.pack.gz");
    }

    public boolean isJnlp() {
        return this.path.endsWith(".jnlp");
    }

    public boolean isJRE() {
        return this.path.endsWith("jre");
    }

    public JRE getJRE() {
        String[] chunks = this.requestedVersion.split("_");
        String ver = chunks[0];
        String build = chunks[1];
        String hash = chunks.length > 2 ? chunks[2] : null;
        String os1 = this.os[0];
        String arch1 = this.arch[0];
        if (OSUtils.isMac((String)os1)) {
            os1 = "macosx";
        }
        os1 = os1.toLowerCase();
        arch1 = arch1.contains("64") ? "x64" : "i586";
        JRE jre = new JRE();
        jre.setVer(ver);
        jre.setBuild(build);
        jre.setHash(hash);
        jre.setOs(os1);
        jre.setArch(arch1);
        return jre;
    }

    public File getCachedJREFile() {
        JRE jre = this.getJRE();
        return new File(MapachoServlet.getCacheDirectory(), jre.getEncodedName() + ".tar.gz");
    }

    public String getJarPath() {
        String name = this.path.substring(0, this.path.indexOf(".jar"));
        String osString = this.os != null ? this.os[0] : "";
        String archString = this.arch != null ? this.arch[0] : "";
        String localeString = this.locale != null ? this.locale[0] : "";
        MapachoArtifact ma = new MapachoArtifact(null, name, osString, archString, localeString, this.requestedVersion, osString != null, null);
        return ma.getJarFileName();
    }

    public boolean isJarExists() {
        String jarPath = this.getJarPath();
        String jarPackGzPath = jarPath + ".pack.gz";
        return this.httpRequest.getServletContext().getRealPath(jarPath) != null || this.httpRequest.getServletContext().getRealPath(jarPackGzPath) != null;
    }

    public File getRequestedVersionJarFile() {
        return this.getFile(this.httpRequest.getServletContext().getRealPath(this.getJarPath()));
    }

    public File getRequestedVersionJarPackGzFile() {
        return this.getFile(this.httpRequest.getServletContext().getRealPath(this.getJarPath() + ".pack.gz"));
    }

    private File getFile(String realPath) {
        if (realPath != null) {
            return new File(realPath);
        }
        return null;
    }

    public File getCurrentVersionCacheJarFile() {
        return this.getCacheJarFile(this.currentVersion);
    }

    public File getRequestedVersionCacheJarFile() {
        return this.getCacheJarFile(this.requestedVersion);
    }

    public File getRequestedVersionCacheJarPackGzFile() {
        return this.getCacheJarPackGzFile(this.requestedVersion);
    }

    public String getCacheDiffBaseName() {
        String diffName = this.getBaseJarFileName() + "-" + this.currentVersion + "-to-" + this.requestedVersion + ".jardiff";
        return diffName;
    }

    public File getCacheDiffFile() {
        return new File(MapachoServlet.getCacheDirectory(), this.getCacheDiffBaseName() + ".pack.gz");
    }

    public File getCacheDiffPackGzFile() {
        String diffName = this.getBaseJarFileName() + "-" + this.currentVersion + "-to-" + this.requestedVersion + ".jardiff.pack.gz";
        return new File(MapachoServlet.getCacheDirectory(), diffName);
    }

    public String getBaseJarFileName() {
        String fileName = this.path.substring(this.path.lastIndexOf("/"), this.path.length());
        return fileName.substring(0, fileName.indexOf(".jar"));
    }

    public File getCacheJarFile(String version) {
        String actualJarFileName = this.getBaseJarFileName() + "__V" + version + ".jar";
        return new File(MapachoServlet.getCacheDirectory(), actualJarFileName);
    }

    public File getCacheJarPackGzFile(String version) {
        File jar = this.getCacheJarFile(version);
        File jarPackGz = new File(jar.getParentFile(), jar.getName() + ".pack.gz");
        return jarPackGz;
    }

    private String getParameter(HttpServletRequest req, String key) {
        String res = req.getParameter(key);
        return res == null ? null : res.trim();
    }

    private static String[] getStringList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int length = str.length();
        StringBuffer sb = null;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                if (sb == null) continue;
                list.add(sb.toString());
                sb = null;
                continue;
            }
            if (ch == '\\') {
                if (i + 1 >= length) continue;
                ch = str.charAt(++i);
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(ch);
                continue;
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(ch);
        }
        if (sb != null) {
            list.add(sb.toString());
        }
        if (list.size() == 0) {
            return null;
        }
        String[] results = new String[list.size()];
        return list.toArray(results);
    }

    private String[] getParameterList(HttpServletRequest req, String key) {
        String res = req.getParameter(key);
        return res == null ? null : DownloadRequest.getStringList(res.trim());
    }

    public String toString() {
        return "DownloadRequest[path=" + this.path + this.showEntry(" realPath=", this.getRealPath()) + this.showEntry(" ifModifiedSince=", this.ifModifiedSince) + this.showEntry(" encoding=", this.encoding) + this.showEntry(" query=", this.query) + this.showEntry(" version=", this.requestedVersion) + this.showEntry(" currentVersionId=", this.currentVersion) + this.showEntry(" os=", this.os) + this.showEntry(" arch=", this.arch) + this.showEntry(" locale=", this.locale) + this.showEntry(" knownPlatforms=", this.knownPlatforms) + " isPlatformRequest=" + this.isPlatformRequest + "]";
    }

    private String showEntry(String msg, Object value) {
        if (value == null) {
            return "";
        }
        return msg + value;
    }

    private String showEntry(String msg, String value) {
        if (value == null) {
            return "";
        }
        return msg + value;
    }

    private String showEntry(String msg, String[] value) {
        if (value == null) {
            return "";
        }
        return msg + Arrays.asList(value).toString();
    }

    public boolean isSupportsGzip() {
        return this.encoding.contains("gzip");
    }

    public boolean isSupportsDeflate() {
        return this.encoding.contains("deflate");
    }

    public String getRealPath() {
        return this.getHttpRequest().getServletContext().getRealPath(this.getPath());
    }

    public boolean fileExists() {
        return this.getFile().exists();
    }

    public File getFile() {
        if (this.isJar()) {
            return this.getRequestedVersionJarPackGzFile();
        }
        log.debug("getFile() realPath" + this.getRealPath());
        return this.getRealPath() != null ? new File(this.getRealPath()) : null;
    }

    public Date getFileLastModified() {
        return this.fileExists() ? new Date(this.getFile().lastModified()) : null;
    }

    public String getFileMimeType() {
        return this.getHttpRequest().getServletContext().getMimeType(this.path);
    }

    public String getPath() {
        return this.path;
    }

    public String getRequestedVersion() {
        return this.requestedVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String[] getOs() {
        return this.os;
    }

    public String[] getArch() {
        return this.arch;
    }

    public String[] getLocale() {
        return this.locale;
    }

    public String[] getKnownPlatforms() {
        return this.knownPlatforms;
    }

    public String getQuery() {
        return this.query;
    }

    public String getAgent() {
        return this.agent;
    }

    public boolean isPlatformRequest() {
        return this.isPlatformRequest;
    }

    public Date getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }
}

