/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorOutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200Strategy;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uno.anahata.mapacho.common.io.CachingOutputStream;
import uno.anahata.mapacho.servlet.DownloadRequest;
import uno.anahata.mapacho.servlet.MapachoServlet;

public abstract class DownloadResponse {
    private static final Logger log = LoggerFactory.getLogger(DownloadResponse.class);
    protected Date lastModified;
    protected String mimeType;
    protected long contentLength;
    protected long realContentLength;
    protected String contentEncoding;
    protected String versionId;
    protected boolean pack = false;
    protected boolean gz = false;
    protected String targetCacheName;

    protected DownloadResponse() {
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        if (lastModified != null) {
            lastModified = new Date(lastModified.getTime() / 1000L * 1000L);
        }
    }

    private OutputStream getOutputStream(HttpServletResponse resp) throws IOException {
        ServletOutputStream effectiveOs = resp.getOutputStream();
        if (this.targetCacheName != null) {
            effectiveOs = new CachingOutputStream((OutputStream)effectiveOs, new File(MapachoServlet.getCacheDirectory(), this.targetCacheName));
        }
        if (this.gz) {
            log.debug("Streaming: " + this + " will gz with commons gz");
            GzipParameters params = new GzipParameters();
            params.setCompressionLevel(9);
            effectiveOs = new GzipCompressorOutputStream((OutputStream)effectiveOs, params);
        }
        if (this.pack) {
            log.debug("Streaming: " + this + " will pack");
            effectiveOs = new Pack200CompressorOutputStream((OutputStream)effectiveOs, Pack200Strategy.IN_MEMORY);
        }
        if (this.pack || this.gz) {
            this.realContentLength = this.contentLength;
            this.contentLength = 0L;
        }
        return effectiveOs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendResponse(DownloadRequest dr, HttpServletResponse resp) throws IOException, ServletException {
        try (InputStream is = this.getInputStream();
             OutputStream os = this.getOutputStream(resp);){
            if (is == null) {
                log.debug("Not Found " + dr);
                resp.sendError(404);
                return;
            }
            if (dr.getIfModifiedSince() != null && !this.lastModified.after(dr.getIfModifiedSince())) {
                log.debug("Not modified " + this);
                resp.sendError(304);
                return;
            }
            if (this.lastModified != null) {
                log.debug("Last-Modified: " + this.contentLength);
                resp.setDateHeader("Last-Modified", this.lastModified.getTime());
            }
            if (this.versionId != null) {
                log.debug("x-java-jnlp-version-id: " + this.versionId);
                resp.setHeader("x-java-jnlp-version-id", this.versionId);
            }
            if (this.contentLength != 0L) {
                log.debug("Content-Length: " + this.contentLength);
                resp.setContentLengthLong(this.contentLength);
            }
            if (this.realContentLength != 0L) {
                log.debug("Real-Content-Length:" + this.realContentLength);
                resp.setHeader("Real-Content-Length", this.realContentLength + "");
            }
            if (this.contentEncoding != null) {
                log.debug("Content-Encoding: " + this.contentEncoding);
                resp.setHeader("Content-Encoding", this.contentEncoding);
            }
            if (this.mimeType != null) {
                log.debug("Content-Type (MimeType): " + this.mimeType);
                resp.setContentType(this.mimeType);
            }
            log.debug("Streaming: " + is);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            return;
        }
        catch (Exception e) {
            log.error("Exception in sendResponse", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected abstract InputStream getInputStream() throws Exception;

    public String toString() {
        return " , lastModified=" + this.lastModified + ", mimeType=" + this.mimeType + ", contentLength=" + this.contentLength + '}';
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getRealContentLength() {
        return this.realContentLength;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public void setPack(boolean pack) {
        this.pack = pack;
    }

    public boolean isPack() {
        return this.pack;
    }

    public void setGz(boolean gz) {
        this.gz = gz;
    }

    public boolean isGz() {
        return this.gz;
    }

    public void setTargetCacheName(String targetCacheName) {
        this.targetCacheName = targetCacheName;
    }

    public String getTargetCacheName() {
        return this.targetCacheName;
    }
}

