/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uno.anahata.mapacho.servlet.DownloadRequest;
import uno.anahata.mapacho.servlet.DownloadResponse;

public class FileDownloadResponse
extends DownloadResponse {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadResponse.class);
    private File file;

    public FileDownloadResponse(DownloadRequest dreq) {
        this(dreq.getFile());
    }

    public FileDownloadResponse(File file) {
        this.setFile(file);
    }

    private void setFile(File file) {
        this.file = file;
        if (file != null) {
            this.lastModified = new Date(file.lastModified() / 1000L * 1000L);
            this.contentLength = file.length();
        }
    }

    @Override
    protected InputStream getInputStream() throws Exception {
        return this.file != null ? new FileInputStream(this.file) : null;
    }

    @Override
    public String toString() {
        return "FileDownloadResponse{file=" + this.file + super.toString();
    }
}

