/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.servlet;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uno.anahata.mapacho.common.http.HttpConnectionUtils;
import uno.anahata.mapacho.common.runtime.JRE;
import uno.anahata.mapacho.servlet.DownloadResponse;

public class JREDownloadResponse
extends DownloadResponse {
    private static final Logger log = LoggerFactory.getLogger(JREDownloadResponse.class);
    private URL url;
    private final JRE jre;

    public JREDownloadResponse(JRE jre) {
        log.info("Info preparing download response of {}", (Object)jre);
        this.jre = jre;
        super.setTargetCacheName(jre.getEncodedName() + ".tar.gz");
        try {
            String urlStr = jre.getOracleWebsiteDownloadURL();
            log.info("JRE download URL from jre.getOracleWebsiteDownloadURL() method :: " + urlStr);
            this.url = new URL(urlStr);
        }
        catch (Exception e) {
            log.error("Exception composing oracle download URL");
            throw new RuntimeException(e);
        }
    }

    @Override
    protected InputStream getInputStream() throws Exception {
        return this.connect(this.url).getInputStream();
    }

    private HttpURLConnection connect(URL url) throws Exception {
        log.info("Connecting to " + url);
        HttpURLConnection localConn = (HttpURLConnection)url.openConnection();
        localConn.setInstanceFollowRedirects(true);
        localConn.setAllowUserInteraction(false);
        localConn.setUseCaches(false);
        localConn.addRequestProperty("Cookie", "oraclelicense=accept-securebackup-cookie");
        System.out.println("Content-type:" + localConn.getContentType());
        System.out.println("Content-encoding:" + localConn.getContentEncoding());
        System.out.println("Content-Length:" + localConn.getContentLengthLong());
        System.out.println("Real-Content-Length:" + localConn.getHeaderField("Real-Content-Length"));
        System.out.println("Response-code:" + localConn.getResponseCode());
        System.out.println("Headers:" + localConn.getHeaderFields());
        String movedTo = HttpConnectionUtils.getMovedToLocation((HttpURLConnection)localConn);
        if (movedTo != null) {
            localConn.disconnect();
            return this.connect(new URL(movedTo));
        }
        this.contentLength = localConn.getContentLengthLong();
        this.contentEncoding = localConn.getContentEncoding();
        this.mimeType = localConn.getContentType();
        this.url = url;
        return localConn;
    }
}

