/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.servlet;

import java.beans.ConstructorProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uno.anahata.mapacho.common.jardiff.JarDiff;
import uno.anahata.mapacho.servlet.DownloadRequest;
import uno.anahata.mapacho.servlet.DownloadResponse;
import uno.anahata.mapacho.servlet.FileDownloadResponse;

public class JarHandler {
    private static final Logger log = LoggerFactory.getLogger(JarHandler.class);
    private final ServletContext servletContext;
    private HashMap<String, DownloadResponse> cache = new HashMap();

    public DownloadResponse getDownloadResponse(DownloadRequest dr) throws IOException {
        if (dr.getRequestedVersion() == null) {
            log.debug("Ignoring non versioned jar request " + dr);
            return null;
        }
        if (!dr.isJarExists()) {
            log.error("Could not locate jar in .jar or .pack.gz for " + dr.getJarPath());
            return null;
        }
        log.debug("Processing versioned jar request " + dr);
        boolean returnFullJar = this.isReturnFullJar(dr);
        File jarFile = dr.getRequestedVersionJarFile();
        File packGzJarFile = dr.getRequestedVersionJarPackGzFile();
        File cacheJarFile = dr.getRequestedVersionCacheJarFile();
        File cacheJarPackGzFile = dr.getRequestedVersionCacheJarPackGzFile();
        log.info("Requested version plain jar cache location: {}" + cacheJarFile);
        if (returnFullJar) {
            if (!cacheJarFile.exists()) {
                if (jarFile != null) {
                    log.info("Requested version plain jar not in cache, copying from {} to {}", (Object)jarFile, (Object)cacheJarFile);
                    JarHandler.copyAsynch(jarFile, cacheJarFile);
                } else {
                    log.info("Requested version plain jar not in cache, unpacking asynchronously {} to {}", (Object)packGzJarFile, (Object)cacheJarFile);
                    JarHandler.unpackAsynch(packGzJarFile, cacheJarFile);
                }
            }
            if (packGzJarFile != null) {
                log.info("returning entire jar in pack200-gzip encoding: {}", (Object)packGzJarFile);
                FileDownloadResponse ret = new FileDownloadResponse(packGzJarFile);
                ret.setContentEncoding("pack200-gzip");
                ret.setMimeType("application/x-java-pack200");
                ret.setVersionId(dr.getRequestedVersion());
                return ret;
            }
            if (cacheJarPackGzFile.exists()) {
                log.info("returning entire jar.pack.gz from cache : {}", (Object)cacheJarPackGzFile);
                FileDownloadResponse ret = new FileDownloadResponse(cacheJarPackGzFile);
                ret.setContentEncoding("pack200-gzip");
                ret.setMimeType("application/x-java-pack200");
                ret.setVersionId(dr.getRequestedVersion());
                return ret;
            }
            log.info("returning entire jar but streaming along the way: {}", (Object)jarFile);
            FileDownloadResponse ret = new FileDownloadResponse(jarFile);
            ret.setPack(true);
            ret.setGz(true);
            ret.setTargetCacheName(cacheJarFile.getName() + ".pack.gz");
            ret.setContentEncoding("pack200-gzip");
            ret.setMimeType("application/x-java-pack200");
            ret.setVersionId(dr.getRequestedVersion());
            return ret;
        }
        File diff = dr.getCacheDiffFile();
        File diffPackGz = dr.getCacheDiffPackGzFile();
        if (diffPackGz.exists()) {
            log.info("JarDiff pack.gz existed in cache, returning diff {} length={}", (Object)diff, (Object)diff.length());
            FileDownloadResponse ret = new FileDownloadResponse(diffPackGz);
            ret.setMimeType("application/x-java-archive-diff");
            ret.setContentEncoding("pack200-gzip");
            ret.setVersionId(dr.getRequestedVersion());
            return ret;
        }
        if (!diff.exists()) {
            if (!cacheJarFile.exists()) {
                if (jarFile != null) {
                    FileUtils.copyFile((File)jarFile, (File)cacheJarFile);
                } else {
                    log.info("Requested version unpacked jar not in cache, unpacking {} to cache {} to generate JarDiff", (Object)packGzJarFile, (Object)cacheJarFile);
                    JarHandler.unpack(packGzJarFile, cacheJarFile);
                }
                log.info("JarDiff {} not in cache, creating , currentVersionSize={}, requesteVersinSize={} ", new Object[]{diff, dr.getCurrentVersionCacheJarFile().length(), cacheJarFile.length()});
            }
            JarHandler.makeJarDiff(dr, cacheJarFile, diff);
        }
        FileDownloadResponse ret = new FileDownloadResponse(diff);
        ret.setMimeType("application/x-java-archive-diff");
        ret.setContentEncoding("pack200-gzip");
        ret.setPack(true);
        ret.setGz(true);
        ret.setTargetCacheName(diffPackGz.getName());
        ret.setVersionId(dr.getRequestedVersion());
        return ret;
    }

    private static void makeJarDiff(DownloadRequest dr, File cacheJarFile, File diff) throws IOException {
        File diffTemp = File.createTempFile(diff.getName(), ".tmp");
        try (FileOutputStream fos = new FileOutputStream(diffTemp);){
            JarDiff.createPatch((File)dr.getCurrentVersionCacheJarFile(), (File)cacheJarFile, (OutputStream)fos, (boolean)true);
        }
        log.info("JarDiff created in temp file size {}", (Object)diffTemp.length());
        FileUtils.deleteQuietly((File)diff);
        diffTemp.renameTo(diff);
        log.info("JarDiff (not packed) stored in cache {} size={}", (Object)diff.length());
    }

    private boolean isReturnFullJar(DownloadRequest dr) {
        boolean returnFullJar = false;
        if (dr.getPath().contains("lib/")) {
            log.info("Request is for lib/ jars, will return entire jar to reduce the chances of javaws bugs");
            returnFullJar = true;
        } else if (dr.getRequestedVersion().equals(dr.getCurrentVersion())) {
            log.info("Request current versionId is same as current version id, returning entire jar");
            returnFullJar = true;
        } else if (dr.getCurrentVersion() == null) {
            log.info("Request current versionId is null, returning entire jar");
            returnFullJar = true;
        } else {
            File currVersionJar = dr.getCurrentVersionCacheJarFile();
            if (!currVersionJar.exists()) {
                log.info("Current version unpacked jar {} not in cache, returning entire jar {}", (Object)currVersionJar);
                returnFullJar = true;
            } else {
                log.info("Current version unpacked jar {} (size = {}) exists in cache, will create jar diff", (Object)currVersionJar, (Object)currVersionJar.length());
            }
        }
        return returnFullJar;
    }

    private static void unpackAsynch(File jarPackGzSource, File jarDest) {
        new Thread(() -> {
            try {
                JarHandler.unpack(jarPackGzSource, jarDest);
            }
            catch (Exception e) {
                log.error("Exception in asynchronous unpack operation");
            }
        }).start();
    }

    private static void copyAsynch(File source, File dest) {
        new Thread(() -> {
            try {
                FileUtils.copyFile((File)source, (File)dest);
            }
            catch (Exception e) {
                log.error("Exception in asynchronous unpack operation");
            }
        }).start();
    }

    private static void unpack(File jarPackGzSource, File jarDest) throws IOException {
        File temp = File.createTempFile(jarDest.getName(), ".tmp");
        log.info("unpacking {} to {}", (Object)jarPackGzSource, (Object)jarDest);
        long ts = System.currentTimeMillis();
        try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(jarPackGzSource)));
             JarOutputStream out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(temp)));){
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            unpacker.unpack((InputStream)in, out);
        }
        FileUtils.deleteQuietly((File)jarDest);
        temp.renameTo(jarDest);
        ts = System.currentTimeMillis() - ts;
        log.info("unpacking {} to {} took {} ms.", new Object[]{jarPackGzSource, jarDest, ts});
    }

    @ConstructorProperties(value={"servletContext"})
    public JarHandler(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

