/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.servlet;

import java.beans.ConstructorProperties;
import java.io.File;
import java.util.HashMap;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uno.anahata.mapacho.common.runtime.JRE;
import uno.anahata.mapacho.servlet.DownloadRequest;
import uno.anahata.mapacho.servlet.DownloadResponse;
import uno.anahata.mapacho.servlet.FileDownloadResponse;
import uno.anahata.mapacho.servlet.JREDownloadResponse;

public class JreHandler {
    private static final Logger log = LoggerFactory.getLogger(JreHandler.class);
    private final ServletContext servletContext;
    private HashMap<String, DownloadResponse> cache = new HashMap();

    public DownloadResponse getDownloadResponse(DownloadRequest dr) {
        JRE jre = dr.getJRE();
        log.info("JRE--> ::" + jre);
        File cachedFile = dr.getCachedJREFile();
        if (cachedFile.exists()) {
            log.info("Requested JRE in cache at: " + cachedFile);
            return new FileDownloadResponse(cachedFile);
        }
        log.info("Requested JRE **NOT** in cache at: " + cachedFile);
        return new JREDownloadResponse(jre);
    }

    @ConstructorProperties(value={"servletContext"})
    public JreHandler(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

