/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uno.anahata.mapacho.servlet.DownloadRequest;
import uno.anahata.mapacho.servlet.DownloadResponse;
import uno.anahata.mapacho.servlet.FileDownloadResponse;
import uno.anahata.mapacho.servlet.JarHandler;
import uno.anahata.mapacho.servlet.JnlpFileHandler;
import uno.anahata.mapacho.servlet.JreHandler;

@WebServlet(name="MapachoServlet", urlPatterns={"/mapacho/*"})
public class MapachoServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(MapachoServlet.class);
    private JnlpFileHandler jnlpHandler;
    private JarHandler jarHandler;
    private JreHandler jreHandler;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.jnlpHandler = new JnlpFileHandler(config.getServletContext());
        this.jarHandler = new JarHandler(config.getServletContext());
        this.jreHandler = new JreHandler(config.getServletContext());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DownloadResponse dresp;
        String requestStr = request.getRequestURI();
        if (request.getQueryString() != null) {
            requestStr = requestStr + "?" + request.getQueryString().trim();
        }
        log.info("Request string {}", (Object)requestStr);
        log.info("Method {}", (Object)request.getMethod());
        log.info("User-Agent {}", (Object)request.getHeader("User-Agent"));
        DownloadRequest dreq = new DownloadRequest(request);
        log.info("Download-Request {}", (Object)dreq);
        if (dreq.isJnlp()) {
            log.info("Request is jnlp");
            dresp = this.jnlpHandler.getJnlpFileEx(dreq);
        } else if (dreq.isJar()) {
            log.info("Request is jar");
            dresp = this.jarHandler.getDownloadResponse(dreq);
            if (dresp == null) {
                response.sendError(404);
                return;
            }
        } else if (dreq.isJRE()) {
            log.info("Request is JRE");
            dresp = this.jreHandler.getDownloadResponse(dreq);
        } else {
            log.info("Request is file");
            dresp = new FileDownloadResponse(dreq);
        }
        log.info("Response is " + dresp);
        dresp.sendResponse(dreq, response);
    }

    public static File getCacheDirectory() {
        File temp = FileUtils.getTempDirectory();
        File jwstemp = new File(temp, "anahata-mapacho-cache");
        if (!jwstemp.exists()) {
            log.info("Creating temp directory " + jwstemp);
            jwstemp.mkdirs();
        }
        return jwstemp;
    }
}

