/*
 * Decompiled with CFR 0.152.
 */
package uno.cod.battle.client;

import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import uno.cod.battle.client.exceptions.BehaviourCode;
import uno.cod.battle.client.exceptions.BehaviourException;
import uno.cod.battle.client.exceptions.CooldownException;
import uno.cod.battle.client.exceptions.InfoException;
import uno.cod.battle.client.model.BattleMap;
import uno.cod.battle.client.model.Direction;
import uno.cod.battle.client.model.GameObject;
import uno.cod.battle.client.model.PlayerType;

public class BattleHelper {
    private final String token;
    private final String serverUrl;
    private ObjectMapper mapper;
    private CloseableHttpClient client;

    public BattleHelper(String token) {
        this(token, "battle.cod.uno");
    }

    public BattleHelper(String token, String serverUrl) {
        this.token = token;
        this.serverUrl = serverUrl;
        this.mapper = new ObjectMapper();
        this.client = HttpClientBuilder.create().build();
    }

    public GameObject me() throws Exception {
        CloseableHttpResponse response = this.get("/me");
        GameObject gameObject = (GameObject)this.mapper.readValue(response.getEntity().getContent(), GameObject.class);
        EntityUtils.consume((HttpEntity)response.getEntity());
        response.close();
        return gameObject;
    }

    public BattleMap map() throws Exception {
        CloseableHttpResponse response = this.get("/map");
        BattleMap battleMap = (BattleMap)this.mapper.readValue(response.getEntity().getContent(), BattleMap.class);
        EntityUtils.consume((HttpEntity)response.getEntity());
        response.close();
        return battleMap;
    }

    public GameObject join(PlayerType type) throws Exception {
        CloseableHttpResponse response = this.post("/join", new JoinParam(type));
        GameObject gameObject = (GameObject)this.mapper.readValue(response.getEntity().getContent(), GameObject.class);
        EntityUtils.consume((HttpEntity)response.getEntity());
        response.close();
        return gameObject;
    }

    public GameObject move(Direction direction) throws Exception {
        CloseableHttpResponse response = this.post("/move", new DirectionParam(direction));
        GameObject gameObject = (GameObject)this.mapper.readValue(response.getEntity().getContent(), GameObject.class);
        EntityUtils.consume((HttpEntity)response.getEntity());
        response.close();
        return gameObject;
    }

    public void attack(Direction direction) throws Exception {
        CloseableHttpResponse response = this.post("/attack", new DirectionParam(direction));
        EntityUtils.consume((HttpEntity)response.getEntity());
        response.close();
    }

    public void spell(int spell, Direction direction, String extra) throws Exception {
        CloseableHttpResponse response = this.post("/spell", new SpellParams(spell, direction, extra));
        EntityUtils.consume((HttpEntity)response.getEntity());
        response.close();
    }

    private CloseableHttpResponse get(String path) throws Exception {
        return this.go((HttpRequestBase)new HttpGet(this.serverUrl + path));
    }

    private CloseableHttpResponse post(String path, Object body) throws Exception {
        HttpPost request = new HttpPost(this.serverUrl + path);
        request.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString(body)));
        return this.go((HttpRequestBase)request);
    }

    private CloseableHttpResponse go(HttpRequestBase request) throws Exception {
        request.addHeader("Authorization", "Token " + this.token);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() != 200) {
            JsonNode obj = this.mapper.readTree(response.getEntity().getContent());
            EntityUtils.consume((HttpEntity)response.getEntity());
            response.close();
            switch (obj.get("type").asText()) {
                case "CooldownError": {
                    throw new CooldownException(obj.get("battleError").get("message").asText(), (long)((double)obj.get("battleError").get("remaining").asLong() / Math.pow(10.0, 6.0)));
                }
                case "InfoError": {
                    throw new InfoException(obj.get("battleError").get("message").asText());
                }
                case "BehaviourError": {
                    throw new BehaviourException(obj.get("battleError").get("behaviour").asText(), (long)((double)obj.get("battleError").get("remaining").asLong() / Math.pow(10.0, 6.0)), BehaviourCode.valueOf(obj.get("battleError").get("code").asText()));
                }
            }
            throw new InfoException("default exception");
        }
        return response;
    }

    private class JoinParam {
        private PlayerType type;

        private JoinParam(PlayerType type) {
            this.type = type;
        }

        public PlayerType getType() {
            return this.type;
        }

        public void setType(PlayerType type) {
            this.type = type;
        }
    }

    private class SpellParams {
        private Integer spell;
        private Direction direction;
        private String extra;

        private SpellParams(Integer spell, Direction direction, String extra) {
            this.spell = spell;
            this.direction = direction;
            this.extra = extra;
        }

        public Integer getSpell() {
            return this.spell;
        }

        public void setSpell(Integer spell) {
            this.spell = spell;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }
    }

    private class DirectionParam {
        private Direction direction;

        public DirectionParam(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }
    }
}

