/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data;

import uno.informatics.data.DataType;

public enum ScaleType {
    NONE("None", "X", DataType.UNKNOWN),
    NOMINAL("Nominal", "N", DataType.STRING),
    ORDINAL("Ordinal", "O", DataType.INTEGER),
    INTERVAL("Interval", "I", DataType.INTEGER),
    RATIO("Ratio", "R", DataType.DOUBLE);

    private String name;
    private String abbreviation;
    private DataType defaultEncoding;
    private static final ScaleType[] allTypes;

    private ScaleType(String name, String abbreviation, DataType defaultEncoding) {
        this.name = name;
        this.abbreviation = abbreviation;
        this.defaultEncoding = defaultEncoding;
    }

    private ScaleType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public DataType getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public static final ScaleType[] getAllTypes() {
        return allTypes;
    }

    public static final ScaleType getTypeByName(String name) {
        ScaleType scaleType = null;
        for (int i = 0; scaleType == null && i < allTypes.length; ++i) {
            if (!allTypes[i].getName().equals(name)) continue;
            scaleType = allTypes[i];
        }
        return scaleType;
    }

    public static final ScaleType getTypeByAbbreviation(String abbreviation) {
        ScaleType scaleType = null;
        for (int i = 0; scaleType == null && i < allTypes.length; ++i) {
            if (!allTypes[i].getAbbreviation().equals(abbreviation)) continue;
            scaleType = allTypes[i];
        }
        return scaleType;
    }

    static {
        allTypes = new ScaleType[]{NONE, NOMINAL, ORDINAL, INTERVAL, RATIO};
    }
}

