/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import cn.hutool.core.codec.Base64;
import com.google.common.io.BaseEncoding;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
@Threads(value=16)
@Fork(value=1, warmups=0)
@Warmup(iterations=1, time=1)
@Measurement(iterations=1, time=1)
public class Base64EncodeBenchmark {
    private byte[] TEST_BYTES;

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(Base64EncodeBenchmark.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    @Setup
    public void setup() {
        this.TEST_BYTES = new byte[16];
        new SecureRandom().nextBytes(this.TEST_BYTES);
    }

    @Benchmark
    public String jdkBase64Encode() {
        return java.util.Base64.getEncoder().encodeToString(this.TEST_BYTES);
    }

    @Benchmark
    public String hutoolBase64Encode() {
        return Base64.encode((byte[])this.TEST_BYTES);
    }

    @Benchmark
    public String guavaBase64Encode() {
        return BaseEncoding.base64().encode(this.TEST_BYTES);
    }
}

