/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import cn.hutool.core.util.HexUtil;
import com.google.common.io.BaseEncoding;
import java.util.HexFormat;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
@Threads(value=16)
@Fork(value=1, warmups=0)
@Warmup(iterations=1, time=1)
@Measurement(iterations=1, time=1)
public class HexBenchmark {
    private byte[] testData;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(HexBenchmark.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    @Setup
    public void setUp() {
        this.testData = new byte[16];
        ThreadLocalRandom.current().nextBytes(this.testData);
    }

    @Benchmark
    public void apacheCommonsCodec(Blackhole bh) {
        bh.consume((Object)Hex.encodeHexString((byte[])this.testData));
    }

    @Benchmark
    public void googleGuava(Blackhole bh) {
        bh.consume((Object)BaseEncoding.base16().encode(this.testData));
    }

    @Benchmark
    public void hutool(Blackhole bh) {
        bh.consume((Object)HexUtil.encodeHexStr((byte[])this.testData));
    }

    @Benchmark
    public void jdk(Blackhole bh) {
        bh.consume((Object)HexFormat.of().formatHex(this.testData));
    }

    @Benchmark
    public void bytes2hex(Blackhole bh) {
        bh.consume((Object)HexBenchmark.bytesToHex(this.testData));
    }

    public static String bytesToHex(byte[] bytes) {
        int length = bytes.length;
        char[] hexChars = new char[length << 1];
        for (int i = 0; i < length; ++i) {
            int value = bytes[i] & 0xFF;
            int index = i << 1;
            hexChars[index] = HEX_ARRAY[value >>> 4];
            hexChars[index + 1] = HEX_ARRAY[value & 0xF];
        }
        return new String(hexChars);
    }
}

