/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import sun.misc.Unsafe;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1)
@State(value=Scope.Benchmark)
public class LongToBytesBenchmark {
    private long testValue = System.currentTimeMillis();
    private static final Unsafe unsafe;
    private static final long BYTE_ARRAY_BASE_OFFSET;

    public static byte[] longToBytesManual(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public static byte[] longToBytesByteBuffer(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }

    public static byte[] longToBytesUnsafe(long value) {
        byte[] bytes = new byte[8];
        unsafe.putLong(bytes, BYTE_ARRAY_BASE_OFFSET, value);
        return bytes;
    }

    @Benchmark
    public void testManual(Blackhole bh) {
        bh.consume((Object)LongToBytesBenchmark.longToBytesManual(this.testValue));
    }

    @Benchmark
    public void testByteBuffer(Blackhole bh) {
        bh.consume((Object)LongToBytesBenchmark.longToBytesByteBuffer(this.testValue));
    }

    @Benchmark
    public void testUnsafe(Blackhole bh) {
        bh.consume((Object)LongToBytesBenchmark.longToBytesUnsafe(this.testValue));
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(LongToBytesBenchmark.class.getSimpleName()).addProfiler("gc").build();
        new Runner(opt).run();
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
            BYTE_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

