/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1)
@Threads(value=100)
@Warmup(iterations=3, time=10, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=10, timeUnit=TimeUnit.SECONDS)
public class PerformanceTest {
    private final AtomicLong atomicLong = new AtomicLong();
    private final LongAdder longAdder = new LongAdder();
    private long longValue;

    @Benchmark
    public void atomicLongIncrement(Blackhole bh) {
        bh.consume(this.atomicLong.incrementAndGet());
    }

    @Benchmark
    public void longAdderIncrement(Blackhole bh) {
        this.longAdder.increment();
        bh.consume(this.longAdder.sum());
    }

    @Benchmark
    public void longValueIncrement(Blackhole bh) {
        bh.consume(++this.longValue);
    }
}

