/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import uno.xifan.id.generator.distributed.cosid.CosIdGenerator;
import uno.xifan.id.generator.distributed.ttsid.TtsIdPlusGenerator;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Threads(value=16)
public class TtsIdVsCosIdBenchmark {
    private RedissonClient redisson;
    private TtsIdPlusGenerator ttsIdGenerator;
    private CosIdGenerator cosIdGenerator;

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(TtsIdVsCosIdBenchmark.class.getSimpleName()).timeUnit(TimeUnit.SECONDS).measurementIterations(5).forks(0).threads(Runtime.getRuntime().availableProcessors()).measurementTime(TimeValue.seconds((long)10L)).build();
        new Runner(opt).run();
    }

    @Setup
    public void setup() {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://xifan.uno:6379").setPassword("qw3erT^&*()_+");
        this.redisson = Redisson.create((Config)config);
        this.ttsIdGenerator = new TtsIdPlusGenerator(this.redisson);
        this.cosIdGenerator = new CosIdGenerator(this.redisson, 44, 20, 16, 0L);
    }

    @TearDown
    public void tearDown() {
        if (this.redisson != null) {
            this.redisson.shutdown();
        }
    }

    @Benchmark
    public void generateTtsId(Blackhole bh) {
        bh.consume((Object)this.ttsIdGenerator.generate());
    }

    @Benchmark
    public void generateCosId(Blackhole bh) {
        bh.consume((Object)this.cosIdGenerator.generate());
    }
}

