/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import com.google.common.io.BaseEncoding;
import java.security.SecureRandom;
import java.util.HexFormat;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base32;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
@Threads(value=16)
@Fork(value=1, warmups=0)
@Warmup(iterations=1, time=1)
@Measurement(iterations=1, time=1)
public class Base32Benchmark {
    private byte[] TEST_BYTES;
    Base32 base32 = new Base32();

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(Base32Benchmark.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    @Setup
    public void setup() {
        this.TEST_BYTES = new byte[16];
        new SecureRandom().nextBytes(this.TEST_BYTES);
    }

    @Benchmark
    public String jdkBase32Encode() {
        return HexFormat.of().formatHex(this.TEST_BYTES);
    }

    @Benchmark
    public String commonsBase32Encode() {
        return this.base32.encodeToString(this.TEST_BYTES);
    }

    @Benchmark
    public String hutoolBase32Encode() {
        return cn.hutool.core.codec.Base32.encode((byte[])this.TEST_BYTES);
    }

    @Benchmark
    public String guavaBase32Encode() {
        return BaseEncoding.base32().encode(this.TEST_BYTES);
    }
}

